<?php
/**
 * File system manipulations
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	die( '-1' );
}


/* Enqueue scripts and styles from child or main theme directory and use .min version
------------------------------------------------------------------------------------- */

// Enqueue .min.css (if exists and filetime .min.css > filetime .css) instead .css
if (!function_exists('trx_addons_enqueue_style')) {	
	function trx_addons_enqueue_style($handle, $src=false, $depts=array(), $ver=null, $media='all') {
		global $TRX_ADDONS_STORAGE;
		$load = true;
		if (!is_array($src) && $src !== false && $src !== '') {
			$theme_dir = get_template_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$theme_url = get_template_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$child_dir = get_stylesheet_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$child_url = get_stylesheet_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$dir = $url = '';
			if (strpos($src, $child_url)===0) {
				$dir = $child_dir;
				$url = $child_url;
			} else if (strpos($src, $theme_url)===0) {
				$dir = $theme_dir;
				$url = $theme_url;
			} else if (strpos($src, $TRX_ADDONS_STORAGE['plugin_url'])===0) {
				$dir = $TRX_ADDONS_STORAGE['plugin_dir'];
				$url = $TRX_ADDONS_STORAGE['plugin_url'];
			}
			if ($dir != '') {
				if (substr($src, -4)=='.css') {
					if (substr($src, -8)!='.min.css') {
						$src_min = substr($src, 0, strlen($src)-4).'.min.css';
						$file_src = $dir . substr($src, strlen($url));
						$file_min = $dir . substr($src_min, strlen($url));
						if (file_exists($file_min) && filemtime($file_src) <= filemtime($file_min)) $src = $src_min;
					}
				}
				$file_src = $dir . substr($src, strlen($url));
				$load = file_exists($file_src) && filesize($file_src) > 0;
			}
		}
		if ($load) {
			if (is_array($src))
				wp_enqueue_style( $handle, $depts, $ver, $media );
			else if (!empty($src) || $src===false)
				wp_enqueue_style( $handle, $src, $depts, $ver, $media );
		}
	}
}

// Enqueue .min.js (if exists and filetime .min.js > filetime .js) instead .js
if (!function_exists('trx_addons_enqueue_script')) {	
	function trx_addons_enqueue_script($handle, $src=false, $depts=array(), $ver=null, $in_footer=true) {
		global $TRX_ADDONS_STORAGE;
		$load = true;
		if (!is_array($src) && $src !== false && $src !== '') {
			$theme_dir = get_template_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$theme_url = get_template_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$child_dir = get_stylesheet_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$child_url = get_stylesheet_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
			$dir = $url = '';
			if (strpos($src, $child_url)===0) {
				$dir = $child_dir;
				$url = $child_url;
			} else if (strpos($src, $theme_url)===0) {
				$dir = $theme_dir;
				$url = $theme_url;
			} else if (strpos($src, $TRX_ADDONS_STORAGE['plugin_url'])===0) {
				$dir = $TRX_ADDONS_STORAGE['plugin_dir'];
				$url = $TRX_ADDONS_STORAGE['plugin_url'];
			}
			if ($dir != '') {
				if (substr($src, -3)=='.js') {
					if (substr($src, -7)!='.min.js') {
						$src_min  = substr($src, 0, strlen($src)-3).'.min.js';
						$file_src = $dir . substr($src, strlen($url));
						$file_min = $dir . substr($src_min, strlen($url));
						if (file_exists($file_min) && filemtime($file_src) <= filemtime($file_min)) $src = $src_min;
					}
				}
				$file_src = $dir . substr($src, strlen($url));
				$load = file_exists($file_src) && filesize($file_src) > 0;
			}
		}
		if ($load) {
			if (is_array($src)) {
				wp_enqueue_script( $handle, $depts, $ver, $in_footer );
			} else if (!empty($src) || $src===false) {
				wp_enqueue_script( $handle, $src, $depts, $ver, $in_footer );
			}
		}
	}
}

//  Enqueue Swiper Slider scripts and styles
if ( !function_exists( 'trx_addons_enqueue_slider' ) ) {
	function trx_addons_enqueue_slider($engine='all') {
		if ($engine=='all' || $engine=='swiper') {
			trx_addons_enqueue_style(  'swiperslider', trx_addons_get_file_url('js/swiper/swiper.css'), array(), null );
			trx_addons_enqueue_script( 'swiperslider', trx_addons_get_file_url('js/swiper/swiper.jquery.js'), array('jquery'), null, true );
		}
	}
}

// Enqueue popup scripts and styles
// Link must have attribute: data-rel="popupEngine" or data-rel="popupEngine[gallery]"
if ( !function_exists( 'trx_addons_enqueue_popup' ) ) {
	function trx_addons_enqueue_popup($engine='') {
		if ($engine=='pretty') {
			trx_addons_enqueue_style(  'prettyphoto',	trx_addons_get_file_url('js/prettyphoto/css/prettyPhoto.css'), array(), null );
			trx_addons_enqueue_script( 'prettyphoto',	trx_addons_get_file_url('js/prettyphoto/jquery.prettyPhoto.min.js'), array('jquery'), 'no-compose', true );
		} else {
			trx_addons_enqueue_style(  'magnific-popup',trx_addons_get_file_url('js/magnific/magnific-popup.css'), array(), null );
			trx_addons_enqueue_script( 'magnific-popup',trx_addons_get_file_url('js/magnific/jquery.magnific-popup.js'), array('jquery'), '', true );
		}
	}
}


/* Check if file/folder present in the child theme and return path (url) to it. 
   Else - path (url) to file in the main theme dir
------------------------------------------------------------------------------------- */
if (!function_exists('trx_addons_get_file_dir')) {	
	function trx_addons_get_file_dir($file, $return_url=false) {
		global $TRX_ADDONS_STORAGE;
		if ($file[0]=='/') $file = substr($file, 1);
		$theme_dir = get_template_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
		$theme_url = get_template_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
		$child_dir = get_stylesheet_directory().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
		$child_url = get_stylesheet_directory_uri().'/'.$TRX_ADDONS_STORAGE['plugin_base'][0].'/';
		$dir = '';
		if (file_exists(($child_dir).($file)))
			$dir = ($return_url ? $child_url : $child_dir).($file);
		else if (file_exists(($theme_dir).($file)))
			$dir = ($return_url ? $theme_url : $theme_dir).($file);
		else if (file_exists(($TRX_ADDONS_STORAGE['plugin_dir']).($file)))
			$dir = ($return_url ? $TRX_ADDONS_STORAGE['plugin_url'] : $TRX_ADDONS_STORAGE['plugin_dir']).($file);
		return $dir;
	}
}

if (!function_exists('trx_addons_get_file_url')) {	
	function trx_addons_get_file_url($file) {
		return trx_addons_get_file_dir($file, true);
	}
}


// Get content from specified file (local or remote)
if (!function_exists('trx_addons_get_file_content')) {	
	function trx_addons_get_file_content($file) {
		$rez = '';
		if (substr($file, 0, 5)=='http:' || substr($file, 0, 6)=='https:') {
			$tm = max(30, ini_get('max_execution_time'));
			$tm = $tm - min(10, round($tm*0.33));
			$response = wp_remote_get($file, array(
									'timeout'     => $tm,
									'redirection' => $tm
									)
								);
			if (is_array($response))
				$rez = $response['body'];
		} else {
			if (($file=trx_addons_get_file_dir($file)) != '')
				$rez = file_get_contents($file);
		}
		return $rez;
	}
}


/* Other file utils
------------------------------------------------------------------------------------- */

// Remove unsafe characters from file/folder path
if (!function_exists('trx_addons_esc')) {	
	function trx_addons_esc($file) {
		return str_replace(array('\\', '~', '$', ':', ';', '+', '>', '<', '|', '"', "'", '`', "\xFF", "\x0A", "\x0D", '*', '?', '^'), '/', trim($file));
	}
}
?>