<?php
if ( !post_password_required() ) {	// && !is_attachment() ) {
	
	if ( is_singular() && !get_query_var('trx_addons_inside_sc') ) {

		if ( is_attachment() ) {
			?>
			<div class="post_featured post_attachment">
				<?php
				do_action('trx_addons_action_before_featured');
				echo wp_get_attachment_image( get_the_ID(), trx_addons_get_thumb_size('full') );
				?>
				
				<nav id="image-navigation" class="navigation image-navigation">
					<div class="nav-previous"><?php previous_image_link( false, '' ); ?></div>
					<div class="nav-next"><?php next_image_link( false, '' ); ?></div>
				</nav><!-- .image-navigation -->
			
			</div><!-- .post_featured -->
			
			<?php
			if ( has_excerpt() ) {
				?><div class="entry-caption"><?php the_excerpt(); ?></div><!-- .entry-caption --><?php
			}

		} else if ( has_post_thumbnail() ) {
			?>
			<div class="post_featured">
				<?php
				do_action('trx_addons_action_before_featured');
				the_post_thumbnail('big', array(
					'alt' => get_the_title(),
					'itemprop' => 'image'
					)
				);
				?>
			</div><!-- .post_featured -->
			<?php
		}

	} else {

		$args = get_query_var('trx_addons_args_featured');
		$post_format = str_replace('post-format-', '', get_post_format());
		$post_info = isset($args['post_info']) ? $args['post_info'] : '';
		$thumb_size = isset($args['thumb_size']) ? $args['thumb_size'] : trx_addons_get_thumb_size('big');
		if ( has_post_thumbnail() ) {
			?><div class="post_featured<?php echo !empty($args['thumb_bg']) ? ' post_featured_bg' : '';  ?>">
				<?php 
				do_action('trx_addons_action_before_featured');
				?>
				<a href="<?php the_permalink(); ?>" aria-hidden="true"><?php 
					if (empty($args['thumb_bg']))
						the_post_thumbnail( $thumb_size, array( 'alt' => get_the_title() ) ); 
					else {
						$src = trx_addons_get_attachment_url( get_post_thumbnail_id( get_the_ID() ), $thumb_size );
						?><span class="post_thumb" style="background-image: url(<?php echo esc_url($src); ?>)"></span><?php
					}
				?></a>
				<?php
				// Post formats over thumb
				if ($post_format == 'audio') {
					$audio = trx_addons_get_post_audio('', false);
					if (empty($audio))
						$audio = trx_addons_get_post_iframe('', false);
					if (!empty($audio)) {
						?><div class="post_audio"><?php echo trim($audio); ?></div><?php
					}
				}
				echo trim($post_info);
				?>
			</div><?php

		} else if ($post_format == 'gallery') {
			if ( ($output = trx_addons_build_slider_layout(array('thumb_size' => $thumb_size))) != '' ) {
				?><div class="post_featured"><!-- <a href="<?php the_permalink(); ?>" aria-hidden="true"> -->
					<?php echo trim($output); ?>
				<!-- </a> --><?php
				echo trim($post_info);
				?></div><?php
			}

		} else if ($post_format == 'image') {
			$image = trx_addons_get_post_image();
			if (!empty($image)) {
				?><div class="post_featured"><a href="<?php the_permalink(); ?>" aria-hidden="true"><?php
					if (empty($args['thumb_bg'])) {
						?><img src="<?php echo esc_url(trx_addons_clear_thumb_size($image)); ?>" alt="<?php echo get_the_title(); ?>"><?php
					} else {
						?><span class="post_thumb" style="background-image: url(<?php echo esc_url(trx_addons_clear_thumb_size($image)); ?>)"></span><?php
					}
				?></a><?php echo trim($post_info); ?></div><?php
			}

		} else if ($post_format == 'video') {
			$video = trx_addons_get_post_video('', false);
			if (empty($video))
				$video = trx_addons_get_post_iframe('', false);
			if (!empty($video)) {
				?><div class="post_featured"><?php echo trim($video); ?></a><?php echo trim($post_info); ?></div><?php
			}

		} else if ($post_format == 'audio') {
			$audio = trx_addons_get_post_audio('', false);
			if (empty($audio))
				$audio = trx_addons_get_post_iframe('', false);
			if (!empty($audio)) {
				if (false && function_exists('wp_read_audio_metadata')) {
					$src = trx_addons_get_post_audio($audio);
					$uploads = wp_upload_dir();
					if (strpos($src, $uploads['baseurl'])!==false) {
						$metadata = wp_read_audio_metadata( $src );
						//dco($metadata);
					}
				}
				?><div class="post_featured"><?php echo trim($audio); ?></a><?php echo trim($post_info); ?></div><?php
			}
		}

	}
}
?>