<?php
/**
 * Widget: Posts or Revolution slider
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */

// Load widget
if (!function_exists('trx_addons_widget_slider_load')) {
	add_action( 'widgets_init', 'trx_addons_widget_slider_load' );
	function trx_addons_widget_slider_load() {
		register_widget( 'trx_addons_widget_slider' );
	}
}

// Widget Class
class trx_addons_widget_slider extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'widget_slider', 'description' => esc_html__('Display theme slider', 'trx_addons') );
		parent::__construct( 'trx_addons_widget_slider', esc_html__('ThemeREX Addons - Posts slider or Revolution slider', 'trx_addons'), $widget_ops );
	}

	// Show widget
	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$engine = isset($instance['engine']) ? $instance['engine'] : 'swiper';

		// Before widget (defined by themes)
		echo trim($before_widget);

		// Display the widget title if one was input (before and after defined by themes)
		if ($title)	echo trim($before_title . $title . $after_title);

		// Widget body
		$html = '';
		if ($engine == 'swiper') {
			$slides_per_view = isset($instance['slides_per_view']) ? $instance['slides_per_view'] : 1;
			$slides_space = isset($instance['slides_space']) ? $instance['slides_space'] : 1;
			$height = isset($instance['height']) ? max(50, (int) $instance['height']) : 345;
			$category = isset($instance['category']) ? (int) $instance['category'] : 0;
			$posts = isset($instance['posts']) ? $instance['posts'] : 5;
			$interval = isset($instance['interval']) ? max(1000, (int) $instance['interval']) : 7000;
			$titles = isset($instance['titles']) ? $instance['titles'] : 'center';
			$large = isset($instance['large']) && $instance['large'] > 0 ? "on" : "off";
			$controls = isset($instance['controls']) && $instance['controls'] > 0 ? "on" : "off";
			$pagination = isset($instance['pagination']) && $instance['pagination'] > 0 ? "on" : "off";
			$count = $ids = $posts;
			if (strpos($ids, ',')!==false) {
				$category = '';
				$count = 0;
			} else {
				$ids = '';
				if (empty($count)) $count = 3;
			}
			if ($count > 0 || !empty($ids)) {
				$html = trx_addons_build_slider_layout(array(
					'mode' => "posts",
					'controls' => $controls,
					'pagination' => $pagination,
					'titles' => $titles,
					'large' => $large,
					'interval' => $interval,
					'height' => $height,
					'per_view' => $slides_per_view,
					'slides_space' => $slides_space,
					'cat' => $category,
					'ids' => $ids,
					'count' => $count,
					'orderby' => "date",
					'order' => "desc",
					'class' => "slider_height_auto"
					)
				);
			}
		} else if ($engine=='revo') {
			$alias = isset($instance['alias']) ? $instance['alias'] : '';
			if (!empty($alias)) {
				$html = do_shortcode('[rev_slider alias="'.esc_attr($alias).'"]');
				if (empty($html)) $html = do_shortcode('[rev_slider '.esc_attr($alias).']');
			}
		}
		if (!empty($html)) {
			?>
			<div class="slider_wrap slider_engine_<?php echo esc_attr($engine); ?><?php if ($engine=='revo') echo ' slider_alias_'.esc_attr($alias); ?>">
				<?php echo trim($html); ?>
			</div>
			<?php 
		}

		// After widget (defined by themes)
		echo trim($after_widget);
	}

	// Update the widget settings.
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		// Strip tags for title and comments count to remove HTML (important for text inputs)
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['engine'] = strip_tags( $new_instance['engine'] );
		$instance['slides_per_view'] = intval( $new_instance['slides_per_view'] );
		$instance['slides_space'] = intval( $new_instance['slides_space'] );
		$instance['height'] = intval( $new_instance['height'] );
		$instance['category'] = intval( $new_instance['category'] );
		$instance['posts'] = strip_tags( $new_instance['posts'] );
		$instance['interval'] = intval( $new_instance['interval'] );
		$instance['titles'] = strip_tags( $new_instance['titles'] );
		$instance['large'] = max(0, min(1, intval( $new_instance['large'] )));
		$instance['controls'] = max(0, min(1, intval( $new_instance['controls'] )));
		$instance['pagination'] = max(0, min(1, intval( $new_instance['pagination'] )));
		if (isset($new_instance['alias']))
			$instance['alias'] = strip_tags( $new_instance['alias'] );

		return $instance;
	}

	// Displays the widget settings controls on the widget panel.
	function form( $instance ) {
		// Set up some default widget settings
		$instance = wp_parse_args( (array) $instance, array(
			'title' => '',
			'engine' => 'swiper',
			'slides_per_view' => '1',
			'slides_space' => '0',
			'height' => '345',
			'alias' => '',
			'titles' => 'center',
			'large' => 0,
			'controls' => 0,
			'pagination' => 0,
			'category' => '0',
			'posts' => '5',
			'interval' => '7000'
			)
		);
		$title = $instance['title'];
		$engine = $instance['engine'];
		$slides_per_view = $instance['slides_per_view'];
		$slides_space = $instance['slides_space'];
		$height = $instance['height'];
		$category = $instance['category'];
		$titles = $instance['titles'];
		$large = $instance['large'];
		$controls = $instance['controls'];
		$pagination = $instance['pagination'];
		$posts = $instance['posts'];
		$interval = $instance['interval'];

		$categories_list = trx_addons_array_merge(array(0=>esc_html__('- Select category -', 'trx_addons')), trx_addons_get_list_categories());
		
		$sliders_list = array(
			"swiper" => esc_html__("Posts slider (Swiper)", 'trx_addons')
		);
		
		if (trx_addons_exists_revslider()) {
			$alias = !empty($instance['alias']) ? $instance['alias'] : '';
			$revo_alias_list = trx_addons_get_list_revo_sliders();
			$sliders_list["revo"] = esc_html__("Layer slider (Revolution)", 'trx_addons');
		}
		
		$titles_list = array(
			'no' => esc_html__('No titles', 'trx_addons'),
			'center' => esc_html__('Center', 'trx_addons'),
			'bottom' => esc_html__('Bottom Center', 'trx_addons'),
			'lb' => esc_html__('Bottom Left', 'trx_addons'),
			'rb' => esc_html__('Bottom Right', 'trx_addons')
		);
		?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($title); ?>" class="widgets_param_fullwidth" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('engine')); ?>"><?php esc_html_e('Slider engine:', 'trx_addons'); ?></label>
			<select id="<?php echo esc_attr($this->get_field_id('engine')); ?>" name="<?php echo esc_attr($this->get_field_name('engine')); ?>" class="widgets_param_fullwidth">
			<?php
				if (is_array($sliders_list) && count($sliders_list) > 0) {
					foreach ($sliders_list as $slug => $name) {
						echo '<option value="'.esc_attr($slug).'"'.($slug==$engine ? ' selected="selected"' : '').'>'.esc_html($name).'</option>';
					}
				}
			?>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'height' )); ?>"><?php esc_html_e('Slider height', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'height' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'height' )); ?>" value="<?php echo esc_attr($height); ?>" class="widgets_param_fullwidth" />
		</p>

		<?php if (trx_addons_exists_revslider()) { ?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('alias')); ?>"><?php esc_html_e('Revolution Slider alias', 'trx_addons'); ?></label>
			<select id="<?php echo esc_attr($this->get_field_id('alias')); ?>" class="widgets_param_fullwidth" name="<?php echo esc_attr($this->get_field_name('alias')); ?>">
			<?php
				if (is_array($revo_alias_list) && count($revo_alias_list) > 0) {
					foreach ($revo_alias_list as $slug => $name) {
						echo '<option value="'.esc_attr($slug).'"'.($slug==$alias ? ' selected="selected"' : '').'>'.esc_html($name).'</option>';
					}
				}
			?>
			</select>
		</p>
		<?php } ?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Category for the Swiper', 'trx_addons'); ?></label>
			<select id="<?php echo esc_attr($this->get_field_id('category')); ?>" name="<?php echo esc_attr($this->get_field_name('category')); ?>" class="widgets_param_fullwidth">
			<?php
				if (is_array($categories_list) && count($categories_list) > 0) {
					foreach ($categories_list as $slug => $name) {
						echo '<option value="'.esc_attr($slug).'"'.($slug==$category ? ' selected="selected"' : '').'>'.esc_html($name).'</option>';
					}
				}
			?>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'slides_per_view' )); ?>"><?php esc_html_e('Slides per view in the Swiper', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'slides_per_view' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'slides_per_view' )); ?>" value="<?php echo esc_attr($slides_per_view); ?>" class="widgets_param_fullwidth" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'slides_space' )); ?>"><?php esc_html_e('Space between slides in the Swiper', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'slides_space' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'slides_space' )); ?>" value="<?php echo esc_attr($slides_space); ?>" class="widgets_param_fullwidth" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'posts' )); ?>"><?php esc_html_e('Swiper posts:', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'posts' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts' )); ?>" value="<?php echo esc_attr($posts); ?>" class="widgets_param_fullwidth" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'interval' )); ?>"><?php esc_html_e('Swiper interval (in msec.)', 'trx_addons'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'interval' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'interval' )); ?>" value="<?php echo esc_attr($interval); ?>" class="widgets_param_fullwidth" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('titles')); ?>"><?php esc_html_e('Show titles in the Swiper', 'trx_addons'); ?></label>
			<select id="<?php echo esc_attr($this->get_field_id('titles')); ?>" name="<?php echo esc_attr($this->get_field_name('titles')); ?>" class="widgets_param_fullwidth">
			<?php
				if (is_array($titles_list) && count($titles_list) > 0) {
					foreach ($titles_list as $slug => $name) {
						echo '<option value="'.esc_attr($slug).'"'.($slug==$titles ? ' selected="selected"' : '').'>'.esc_html($name).'</option>';
					}
				}
			?>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('large')); ?>_1"><?php esc_html_e('Show large titles:', 'trx_addons'); ?></label><br />
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('large')); ?>_1" name="<?php echo esc_attr($this->get_field_name('large')); ?>" value="1" <?php echo (1==$large ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('large')); ?>_1"><?php esc_html_e('Large', 'trx_addons'); ?></label>
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('large')); ?>_0" name="<?php echo esc_attr($this->get_field_name('large')); ?>" value="0" <?php echo (0==$large ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('large')); ?>_0"><?php esc_html_e('Small', 'trx_addons'); ?></label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('controls')); ?>_1"><?php esc_html_e('Show arrows:', 'trx_addons'); ?></label><br />
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('controls')); ?>_1" name="<?php echo esc_attr($this->get_field_name('controls')); ?>" value="1" <?php echo (1==$controls ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('controls')); ?>_1"><?php esc_html_e('Show', 'trx_addons'); ?></label>
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('controls')); ?>_0" name="<?php echo esc_attr($this->get_field_name('controls')); ?>" value="0" <?php echo (0==$controls ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('controls')); ?>_0"><?php esc_html_e('Hide', 'trx_addons'); ?></label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('pagination')); ?>_1"><?php esc_html_e('Show pagination:', 'trx_addons'); ?></label><br />
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('pagination')); ?>_1" name="<?php echo esc_attr($this->get_field_name('pagination')); ?>" value="1" <?php echo (1==$pagination ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('pagination')); ?>_1"><?php esc_html_e('Show', 'trx_addons'); ?></label>
			<input type="radio" id="<?php echo esc_attr($this->get_field_id('pagination')); ?>_0" name="<?php echo esc_attr($this->get_field_name('pagination')); ?>" value="0" <?php echo (0==$pagination ? ' checked="checked"' : ''); ?> />
			<label for="<?php echo esc_attr($this->get_field_id('pagination')); ?>_0"><?php esc_html_e('Hide', 'trx_addons'); ?></label>
		</p>
		
	<?php
	}
}



// trx_widget_slider
//-------------------------------------------------------------
/*
[trx_widget_slider id="unique_id" title="Widget title" engine="revo" alias="home_slider_1"]
*/
if ( !function_exists( 'trx_addons_sc_widget_slider' ) ) {
	function trx_addons_sc_widget_slider($atts, $content=null){	
		$atts = trx_addons_html_decode(shortcode_atts(apply_filters('trx_addons_sc_atts', array(
			// Individual params
			'title' => '',
			'engine' => 'swiper',
			'slides_per_view' => '1',
			'slides_space' => '0',
			'height' => '345',
			'alias' => '',
			'category' => '0',
			'posts' => '5',
			'interval' => '7000',
			'titles' => 'center',
			'large' => 0,
			'controls' => 0,
			'pagination' => 0,
			// Common params
			"id" => "",
			"class" => "",
			"css" => ""
		), 'trx_widget_slider'), $atts));
		extract($atts);
		$type = 'trx_addons_widget_slider';
		$output = '';
		global $wp_widget_factory, $TRX_ADDONS_STORAGE;
		if ( is_object( $wp_widget_factory ) && isset( $wp_widget_factory->widgets, $wp_widget_factory->widgets[ $type ] ) ) {
			$output = '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
							. ' class="widget_area sc_widget_slider' 
								. (trx_addons_exists_visual_composer() ? ' vc_widget_slider wpb_content_element' : '') 
								. (!empty($class) ? ' ' . esc_attr($class) : '') 
								. '"'
							. ($css ? ' style="'.esc_attr($css).'"' : '')
						. '>';
			ob_start();
			the_widget( $type, $atts, trx_addons_prepare_widgets_args($TRX_ADDONS_STORAGE['widgets_args'], $id ? $id.'_widget' : 'widget_slider', 'widget_slider') );
			$output .= ob_get_contents();
			ob_end_clean();
			$output .= '</div>';
		}
		return apply_filters('trx_addons_sc_output', $output, 'trx_widget_slider', $atts, $content);
	}
	add_shortcode("trx_widget_slider", "trx_addons_sc_widget_slider");
}


// Add [trx_widget_slider] in the VC shortcodes list
if (!function_exists('trx_addons_sc_widget_slider_add_in_vc')) {
	function trx_addons_sc_widget_slider_add_in_vc() {

		if (!trx_addons_exists_visual_composer()) return;
		
		$titles_list = array(
			'no' => esc_html__('No titles', 'trx_addons'),
			'center' => esc_html__('Center', 'trx_addons'),
			'bottom' => esc_html__('Bottom Center', 'trx_addons'),
			'lb' => esc_html__('Bottom Left', 'trx_addons'),
			'rb' => esc_html__('Bottom Right', 'trx_addons')
		);
		
		$sliders_list = array(
			"swiper" => esc_html__("Posts slider (Swiper)", 'trx_addons')
		);
		if (trx_addons_exists_revslider()) {
			$sliders_list["revo"] = esc_html__("Layer slider (Revolution)", 'trx_addons');
		}
		
		$params = array(
					array(
						"param_name" => "title",
						"heading" => esc_html__("Widget title", 'trx_addons'),
						"description" => wp_kses_data( __("Title of the widget", 'trx_addons') ),
						"admin_label" => true,
						"type" => "textfield"
					),
					array(
						"param_name" => "engine",
						"heading" => esc_html__("Slider engine", 'trx_addons'),
						"description" => wp_kses_data( __("Select engine to show slider", 'trx_addons') ),
						"admin_label" => true,
						"value" => array_flip($sliders_list),
						"type" => "dropdown"
					),
					array(
						"param_name" => "height",
						"heading" => esc_html__("Slider height", 'trx_addons'),
						"description" => wp_kses_data( __("Slider height", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"value" => "345",
						"type" => "textfield"
					)
				);
		if (trx_addons_exists_revslider()) {
			$params[] = array(
						"param_name" => "alias",
						"heading" => esc_html__("RevSlider alias", 'trx_addons'),
						"description" => wp_kses_data( __("Select previously created Revolution slider", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'revo'
						),
						"value" => array_flip(trx_addons_get_list_revo_sliders()),
						"type" => "dropdown"
					);
		}
		$params = array_merge($params, array(		
					array(
						"param_name" => "category",
						"heading" => esc_html__("Category for the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Select category to get posts for the slider", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"std" => 0,
						"value" => array_flip(trx_addons_array_merge(array(0=>esc_html__('- Select category -', 'trx_addons')), trx_addons_get_list_categories())),
						"type" => "dropdown"
					),
					array(
						"param_name" => "posts",
						"heading" => esc_html__("Posts for the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Number posts or comma separated post IDs to show in the Swiper", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"value" => "5",
						"type" => "textfield"
					),
					array(
						"param_name" => "slides_per_view",
						"heading" => esc_html__("Slides per view in the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Specify slides per view in the Swiper", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "slides_space",
						"heading" => esc_html__("Space between slides in the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Space between slides in the Swiper", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"value" => "0",
						"type" => "textfield"
					),
					array(
						"param_name" => "interval",
						"heading" => esc_html__("Interval between slides in the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Specify interval between slides change in the Swiper", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"value" => "7000",
						"type" => "textfield"
					),
					array(
						"param_name" => "titles",
						"heading" => esc_html__("Titles in the Swiper", 'trx_addons'),
						"description" => wp_kses_data( __("Show post's titles and categories on the slides", 'trx_addons') ),
						'dependency' => array(
							'element' => 'engine',
							'value' => 'swiper'
						),
						"std" => "center",
						"value" => array_flip($titles_list),
						"type" => "dropdown"
					),
					array(
						"param_name" => "large",
						"heading" => esc_html__("Large titles", 'trx_addons'),
						"description" => wp_kses_data( __("Do you want use large titles?", 'trx_addons') ),
						"std" => "0",
						"value" => array("Large titles" => "1" ),
						"type" => "checkbox"
					),
					array(
						"param_name" => "controls",
						"heading" => esc_html__("Show controls", 'trx_addons'),
						"description" => wp_kses_data( __("Do you want to show arrows to change slides?", 'trx_addons') ),
						"std" => "0",
						"value" => array("Arrows" => "1" ),
						"type" => "checkbox"
					),
					array(
						"param_name" => "pagination",
						"heading" => esc_html__("Show pagination", 'trx_addons'),
						"description" => wp_kses_data( __("Do you want to show bullets to change slides?", 'trx_addons') ),
						"std" => "0",
						"value" => array("Bullets" => "1" ),
						"type" => "checkbox"
					),
					// Common VC parameters
					'id' => array(
						"param_name" => "id",
						"heading" => esc_html__("Element ID", 'trx_addons'),
						"description" => wp_kses_data( __("ID for current element", 'trx_addons') ),
						"group" => esc_html__('ID &amp; Class', 'trx_addons'),
						"type" => "textfield"
					),
					'class' => array(
						"param_name" => "class",
						"heading" => esc_html__("Element CSS class", 'trx_addons'),
						"description" => wp_kses_data( __("CSS class for current element", 'trx_addons') ),
						"group" => esc_html__('ID &amp; Class', 'trx_addons'),
						"type" => "textfield"
					),
					'css' => array(
						'param_name' => 'css',
						'heading' => __( 'CSS box', 'trx_addons' ),
						'group' => __( 'Design Options', 'trx_addons' ),
						'type' => 'css_editor'
					)
				)
			);
		
		vc_map( apply_filters('trx_addons_sc_map', array(
				"base" => "trx_widget_slider",
				"name" => esc_html__("Widget Slider", 'trx_addons'),
				"description" => wp_kses_data( __("Insert widget with slider", 'trx_addons') ),
				"category" => esc_html__('ThemeREX', 'trx_addons'),
				"icon" => 'icon_trx_widget_slider',
				"class" => "trx_widget_slider",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => $params
			), 'trx_widget_slider' ) );
			
		class WPBakeryShortCode_Trx_Widget_Slider extends WPBakeryShortCode {}

	}
	add_action('after_setup_theme', 'trx_addons_sc_widget_slider_add_in_vc', 11);
}
?>