<?php 
// Backwards compatible version of Divi's et_before_main_content action 
// - https://www.elegantthemes.com/documentation/developers/hooks/divi-template-hooks/
// - Fires after the header, before the main content is output.
// - Doesn't support Divi < 2.6ish, as 'et_builder_ready' hook not available

add_action('et_builder_ready', 'dbbc_add_before_main_content_action', 11); // Load after modules
$dbbc_before_main_content = ''; // Using a global for PHP 5.2 support

function dbbc_add_before_main_content_action() {
	
	global $themename, $dbbc_before_main_content;
	
	// === Use built in action if available ===
	
	$is_divi = (!empty($themename) && $themename === 'Divi');
	$is_core_3_1 = (defined('ET_CORE_VERSION') && (version_compare(ET_CORE_VERSION, '3.1') >= 0));
	$built_in_action = ($is_divi && $is_core_3_1);
	
	if ($built_in_action) {
		
		// Hook into the built-in main divi action
		add_action('et_before_main_content', 'dbbc_do_before_main_content');
		
		return;
	} 
	
	// === Otherwise use backwards compatible version ===
	
	$output_buffering_enabled = (ob_get_level() > 0);
	
	if ($output_buffering_enabled) {
			
		// Get action output
		// - Run early as won't run correctly in ob_start callback due to WP shutting down
		ob_start();
		do_action('dbbc_before_main_content');
		$dbbc_before_main_content = ob_get_clean();

		// Start and filter an output buffer of the page contents
		ob_start('dbbc_before_main_content_buffer');
		
		return;
	}
}

function dbbc_do_before_main_content() {
	do_action('dbbc_before_main_content');
}

function dbbc_before_main_content_buffer($content) {
	global $dbbc_before_main_content;
	return str_replace('<div id="main-content"', $dbbc_before_main_content.'<div id="main-content"', $content);
}