<?php
/*
Plugin Name: Divi Breadcrumbs Module
Plugin URI: 
Description: Adds a breadcrumbs module to the Divi Builder
Author: Divi Booster
Version: 1.2.2
Author URI: http://www.divibooster.com
*/

define('DMB_BREADCRUMBS_VERSION', '1.2.2');
define('DBDBM_FILE', __FILE__);

// === Updates ===
$updatename = 'divi-module-breadcrumbs';
$updateurl = 'https://divibooster.com/plugins/?action=get_metadata&slug='.$updatename;
include_once(dirname(__FILE__).'/wp-plugin-update-class/plugin-update-checker.php');
try {
	$MyUpdateChecker = new DMWP_PluginUpdateChecker_1_0_0($updateurl, __FILE__, $updatename);
} catch (Exception $e) { echo "Update error: ".$e->getMessage(); exit; }

// Load custom module class
include_once(dirname(__FILE__).'/custom-module-class/divi-builder-custom-module.class.php');

// Load hooks
include_once(dirname(__FILE__).'/hooks.php');
foreach(glob(dirname(__FILE__).'/actions/dbbc_*.php') as $action) { 
	include_once($action); 
}

// Compatibility
include_once(dirname(__FILE__).'/compat/divi-den-pro/divi-den-pro.php');

// === Load features ===

include_once(dirname(__FILE__).'/features/001-site-wide-breadcrumbs.php');


// === Load module ===

include_once(dirname(__FILE__).'/modules/et_pb_dmb_breadcrumbs/et_pb_dmb_breadcrumbs.php');

function load_DMB_Module_Breadcrumbs() {
	
	if (class_exists('DMB_Custom_Divi_Module_1_0_7')) { 

		class DMB_Module_Breadcrumbs extends DMB_Custom_Divi_Module_1_0_7 {
			
			public $vb_support = 'partial';
			
			var $crumbs = array();
			
			function init() {
				
				$this->set_slug('et_pb_dmb_breadcrumbs'); 
			
				$this->name            = 'Breadcrumbs';
				$this->icon 		   = '&#x39;'; // Icon code from https://www.elegantthemes.com/blog/resources/elegant-icon-font
				
				$this->handle_plugin_update(DMB_BREADCRUMBS_VERSION);
			
				// === General Settings tab ===
				$this->set_tab('general');
				
				$this->add_admin_label_field();
				
				// === Advanced Settings tab === 
				$this->set_tab('advanced');
					
				// Text Styling
				$this->add_heading('text_styles', 'Text Styling');
				
				$this->add_yes_no_field('show_final_breadcrumb', 'Show Final Breadcrumb', array(
					'description' => "Choose whether or not to show the breadcrumb item for the current page (e.g. the page / post title)",
					'default' => 'on'
				));
				
				$this->add_font_options('body', 'Breadcrumb', array(
					'css' => array(
						'main' => "{$this->main_css_element} li"
					),
					'hide_line_height' => true,
					'hide_letter_spacing' => true,
				));
				
				// Separator Styling
				$this->add_heading('separator_styles', 'Separator Styling');
								
				$this->add_font_icon_field('font_icon', 'Separator', array(	
					'option_category'     => 'basic_option',
					'description'         => 'Choose an icon to separate breadcrumb items.',
					'default'	=> '%%24%%', // icon position count, indexed from zero
				));
				
				$this->add_font_options('separator', 'Separator', array(
					'css' => array(
						'main' => "{$this->main_css_element} li+li:before"
					),
					'hide_line_height' => true,
					'hide_letter_spacing' => true,
					'hide_font' => true
				));
				
				// Link Styling
				$this->add_heading('link_styles', 'Link Styling');
				
				$this->add_font_options('link', 'Link', array(
					'css' => array(
						'main' => "{$this->main_css_element} li a"
					),
					'hide_line_height' => true,
					'hide_letter_spacing' => true
				));
				
				$this->add_font_options('linkhover', 'Link Hover', array(
					'css' => array(
						'main' => "{$this->main_css_element} li a:hover"
					),
					'hide_line_height' => true,
					'hide_letter_spacing' => true
				));
				
				// Home Link Styling
				$this->add_heading('home_styles', 'Home Link Styling');
								
				$this->add_yes_no_field('use_home_icon', 'Use Home Icon', array(
					'children'=>array('home_icon'),
					'default'=>'on',
				));
				
				$this->add_font_icon_field('home_icon', 'Home Icon', array(	
					'description'         => 'Choose an icon for the home link.',
					'default'	=> '%%102%%', // icon position count, indexed from zero
				));		
				
				$this->add_yes_no_field('use_home_text', 'Use Custom Home Text', array(
					'children'=>array('home_text')
				));
				
				$this->add_text_field('home_text', 'Custom Home Text', array(	
					'description'       => 'Choose text for the home link.' 
				));	
				
				// Module Styling
				$this->add_heading('module_styles', 'Module Styling');
				
				$this->add_background_option(array(
					'settings'=>array(
						'color'=>'alpha'
					)
				));
				
				$this->add_border_option();
				$this->add_margin_padding_option(array(
					'css' => array(
						'important' => 'all',
					)
				));
				
				// === Custom CSS tab ===
				$this->set_tab('custom_css');
			
				$this->add_css_id_field();
				$this->add_css_class_field();
				$this->add_custom_css_box('breadcrumb_list', 'Breadcrumb List', 'ol');
				$this->add_custom_css_box('breadcrumb_item', 'Breadcrumb Item', 'li');
				$this->add_custom_css_box('breadcrumb_item_link', 'Breadcrumb Item Link', 'li a');
				$this->add_custom_css_box('breadcrumb_item_link_hover', 'Breadcrumb Item Link Hover', 'li a:hover');
				$this->add_custom_css_box('breadcrumb_separator', 'Breadcrumb Item Separator', 'li+li:before');
				
				// === Create the module ===
				
				add_action('wp_enqueue_scripts', array($this, 'register_scripts'));		
			
				$this->prepare();
			}
			
			// Divi 3.1+
			public function get_settings_modal_toggles() {
				return $this->options_toggles;
			}

			// Divi 3.1+ - replaces advanced field types added above (which are kept for backwards compatibility
			public function get_advanced_fields_config() {
				return array(
					'background' => array(),
					'margin_padding' => array(
						'css' => array(
							'important' => 'all',
						),
					),	
					'fonts' => array(
						'body' => array(
							'css' => array(
								'main' => "{$this->main_css_element} ol"
							),
							'label' => 'Breadcrumb',
							'toggle_slug' => 'text_styles',
							'tab_slug' => 'advanced'
						),
						'separator' => array(
							'css' => array(
								'main' => "{$this->main_css_element} li+li:before"
							),
							'label' => 'Separator',
							'hide_letter_spacing' => true,
							'hide_font' => true,
							'hide_text_align' => true,
							'toggle_slug' => 'separator_styles',
							'tab_slug' => 'advanced'
						),
						'link' => array(
							'css' => array(
								'main' => "{$this->main_css_element} li a"
							),
							'label' => 'Link',
							'hide_text_align' => true,
							'toggle_slug' => 'link_styles',
							'tab_slug' => 'advanced'
						),
						'linkhover' => array(
							'css' => array(
								'main' => "{$this->main_css_element} li a:hover"
							),
							'label' => 'Link Hover',
							'hide_text_align' => true,
							'toggle_slug' => 'link_styles',
							'tab_slug' => 'advanced'
						),
					),
				);
			}
			
			function register_scripts() { 
				// Load module styles
				wp_register_style($this->slug.'-css', plugins_url('style.css', __FILE__));
				
				if (function_exists('et_fb_enabled') and et_fb_enabled()) {
					// Enqueue CSS right away if using visual builder
					wp_enqueue_style($this->slug.'-css');
				}
	
			}
			
			function shortcode_atts() {
				$this->shortcode_atts['separator_font'] = ''; // Prevent notices when hide_font used in advanced font options	
			}
			
			function shortcode_fn($id, $classes, $atts, $content = null, $function_name) {
				
				// Load the default CSS
				wp_enqueue_style($this->slug.'-css');
				
				// Get the icon codes
				$sepicon = html_entity_decode(et_pb_process_font_icon($atts['font_icon']));
				$homeicon = html_entity_decode(et_pb_process_font_icon($atts['home_icon']));
				
				$use_home_icon = ($atts['use_home_icon']==='off')?false:true;
				$show_final_breadcrumb = ($atts['show_final_breadcrumb']==='off')?false:true;
				
				return $this->module_div($id, $classes, $this->breadcrumbs($atts, $homeicon, $use_home_icon, $sepicon, $show_final_breadcrumb));
			}
			
			function add_crumb($text, $url='') {
				$this->crumbs[] = array('url'=>$url, 'text'=>$text);
			}
			
			// Generate breadcrumbs. 
			// Adapted from https://www.thewebtaylor.com/articles/wordpress-creating-breadcrumbs-without-a-plugin
			function breadcrumbs($atts, $homeicon, $use_home_icon, $sepicon, $show_final_breadcrumb) {
				
				// If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
				$custom_taxonomy  = 'product_cat';
				   
				$post_id = dbbcm_get_post_id();
				$post = get_post($post_id);
				$post_type = $post->post_type;
				$is_single = ($post_type !== 'page'); // NB: is_single() doesn't work in VB ajax request
				
				$this->crumbs = array();
				   
				// Add home page crumb
				$use_custom_home_text = (isset($atts['use_home_text']) and $atts['use_home_text']==='on');
				$custom_home_text = empty($atts['home_text'])?'':$atts['home_text'];
				$home_text = $use_custom_home_text?$custom_home_text:__('Home');
				$this->add_crumb($home_text, get_home_url()); // Home	
				
				if (is_archive() && is_tax() && !is_category() && !is_tag()) {
					  
					// If post is a custom post type
					$archive_post_type = get_post_type();
					  
					// If it is a custom post type display name and link
					if ($archive_post_type !== 'post') { 
						$this->add_crumb(get_post_type_object($archive_post_type)->labels->name, get_post_type_archive_link($archive_post_type)); 
					}
					$this->add_crumb(get_queried_object()->name); // custom taxonomy name
				} 
				elseif ($is_single) {
					  
					// If it is a custom post type display name and link
					if($post_type != 'post') { 
						$this->add_crumb(get_post_type_object($post_type)->labels->name, get_post_type_archive_link($post_type));
					}
					  
					// Get post category info
					$category = get_the_category($post_id);
					 
					if(!empty($category)) {
					  
						// Get last category post is in
						$cats = array_values($category);
						$last_category = end($cats);
						  
						// Loop through parent categories							
						$cat_crumbs = array();
						$get_cat_parents = rtrim(get_category_parents($last_category->term_id, false, ','),',');
						foreach(explode(',',$get_cat_parents) as $parent) {
							$url = get_category_link(get_cat_ID($parent));
							$cat_crumbs[] = array('url'=>$url, 'text'=>$parent);
						}
					}
					  
					// If it's a custom post type within a custom taxonomy
					if(empty($last_category) && !empty($custom_taxonomy) && taxonomy_exists($custom_taxonomy)) {
						$taxonomy_terms = get_the_terms($post_id, $custom_taxonomy);
						$cat_id         = $taxonomy_terms[0]->term_id;
						$cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
						$cat_name       = $taxonomy_terms[0]->name;
					}
					 
					if (!empty($last_category)) { // Check if the post is in a category
						foreach($cat_crumbs as $c) {
							$this->add_crumb($c['text'], $c['url']);
						}
					} 
					elseif (!empty($cat_id)) { // Else if post is in a custom taxonomy
						$this->add_crumb($cat_name, $cat_link);
					} 
					
					$this->add_crumb(get_the_title($post_id));
					  
				} 
				elseif (is_category()) { // Category page 
					// Loop through parent cats
					$category = get_category( get_query_var( 'cat' ) );
					$cat_id = $category->cat_ID;
					
					$get_cat_parents = explode(',',rtrim(get_category_parents($cat_id, false, ','),','));
					$last_category = end($get_cat_parents);
					foreach($get_cat_parents as $parent) {
						if ($parent!==$last_category) {
							$url = get_category_link(get_cat_ID($parent));
							$this->add_crumb($parent, $url);
						}
					}
					
					$this->add_crumb(single_cat_title('', false));
					
				} elseif ($post->post_type === 'page') { // Pages
				
					if($post->post_parent){
						// Loop through page parents
						foreach (array_reverse(get_post_ancestors($post->ID)) as $ancestor ) {
							$this->add_crumb(get_the_title($ancestor), get_permalink($ancestor));
						}							   
					} 
					
					if (function_exists('WC') && is_account_page()) { // Woocommerce subpage
					
						// Handle woocommerce account subpages
						$query = WC()->query;
						$endpoint = $query->get_current_endpoint();
						$endpoint_title = $query->get_endpoint_title($endpoint);
						
						if (empty($endpoint_title)) { // Account dashboard, so no subpage link
							$this->add_crumb(get_the_title());
						} else {
							$this->add_crumb(get_the_title(), get_permalink()); // Current page with url
							$this->add_crumb($endpoint_title);
						}
						
					} else { // Standard page
					
						$this->add_crumb($post->post_title); // Current page

					}
				} 
				elseif (is_tag()) { // Tag archive
					$term_id        = get_query_var('tag_id');
					$terms          = get_terms('post_tag', "include=$term_id");
					$get_term_name  = $terms[0]->name;
					$this->add_crumb($get_term_name);
				} 
				elseif (is_day()) { // Day archive					
					$this->add_crumb(get_the_time('Y'), get_year_link(get_the_time('Y'))); // Year
					$this->add_crumb(get_the_time('M'), get_month_link(get_the_time('Y'), get_the_time('m'))); // Month
					$this->add_crumb(get_the_time('jS').' '.get_the_time('M'));
				} 
				elseif (is_month()) { // Month Archive
					$this->add_crumb(get_the_time('Y'), get_year_link(get_the_time('Y'))); // Year
					$this->add_crumb(get_the_time('M')); 
				} 
				elseif (is_year()) { // Year
					$this->add_crumb(get_the_time('Y')); 
				} 
				elseif (is_author()) { // Author archive  
					global $author;
					$userdata = get_userdata($author);
					$this->add_crumb('Author: '.$userdata->display_name);
				} 
				elseif (get_query_var('paged')) { // Paginated archives
					$this->add_crumb(__('Page').' '.get_query_var('paged')); 
				} 
				elseif (is_search()) { // Search results page	
					$this->add_crumb('Search results for: '.get_search_query());
				}    
				elseif (is_404()) { // 404 page
					$this->add_crumb('Error 404'); 
				}
				elseif (is_archive() && !is_tax() && !is_category() && !is_tag() && !is_author()) {	// archive
					$this->add_crumb(post_type_archive_title('', false)); 
				} 
				
				// === Output the breadcrumbs ===
				$crumbs = '';					
				$count = 1;
				
				// Remove the final breadcrumb (i.e. current page crumb) if not wanted
				if (!$show_final_breadcrumb) {
					$this->crumbs = array_slice($this->crumbs, 0, -1);
				}
				
				$schema_enabled = apply_filters('et_pb_dmb_breadcrumbs_schema_enabled', true);
				
				foreach($this->crumbs as $k=>$c) {
					if ($use_home_icon && $count==1) {
						$homeiconattr = 'data-icon="'.esc_attr($homeicon).'"';
					} else {
						$homeiconattr = 'data-icon=""';
					}
					
					// Don't add "home" crumb if no home icon or text
					if ($count === 1 && !$use_home_icon && empty(trim($c['text']))) {
						continue;
					}
					
					$sepiconattr = ($count>1?'data-icon="'.esc_attr($sepicon).'"':'');
						
					// Define the schema markup
					$use_schema = ($schema_enabled && !empty($c['url']) && !empty($c['text']));
					$use_schema = apply_filters('et_pb_dmb_breadcrumbs_generate_schema', $use_schema);
					$schema_li = $use_schema?' property="itemListElement" typeof="ListItem"':'';
					$schema_a = $use_schema?' property="item" typeof="WebPage"':'';
					$schema_name = $use_schema?' property="name"':'';
					$schema_pos = $use_schema?'<meta property="position" content="'.esc_attr($count).'"/>':'';
					
					// Define the markup for the crumb
					if (empty($c['url'])) { 
						$crumb = '<li '.$sepiconattr.'><span>'.esc_html($c['text']).'</span></li>';
					} else { 
						$crumb = '<li '.$sepiconattr.$schema_li.'><a href="'.esc_attr($c['url']).'" '.$homeiconattr.$schema_a.'><span'.$schema_name.'>'.esc_html($c['text']).'</span></a>'.$schema_pos.'</li>';
					}

					$crumbs.= $crumb;
					$count++;
				}
				$schema_ol = $schema_enabled?' vocab="http://schema.org/" typeof="BreadcrumbList"':'';
				$crumbs = '<ol'.$schema_ol.'>'.$crumbs.'</ol>';
				
				$this->crumbs = array(); // Clear crumbs var for next module
				
				return $crumbs;				   
			}

		}
		new DMB_Module_Breadcrumbs;
		
	}
}
add_action('et_builder_ready', 'load_DMB_Module_Breadcrumbs');

function dbbcm_get_post_id() {
	global $post;			
	$post_id = $post->ID;
	if (dbbcm_is_visual_builder()) {
		if (isset($_POST['options']['current_page']['id'])) {
			$post_id = $_POST['options']['current_page']['id'];
		}
	}
	return intval($post_id);
}

function dbbcm_is_visual_builder() {
	return wp_doing_ajax();
}

// === Exclude breadcrumbs from extracts, etc ===

add_filter('the_content', 'DMB_remove_unwanted_breadcrumbs');
add_filter('db_breadcrumbs_filter_et_pb_layout', 'DMB_remove_unwanted_breadcrumbs');

function DMB_remove_unwanted_breadcrumbs($content) {
	
	$show_breadcrumbs = true;
	
	// Don't show when used in extracts in main loops
	if (is_main_query() && (is_home() || is_archive() || is_search())) {
		$show_breadcrumbs = false;
	}

	// Remove the shortcode when content is for extract
	if (!$show_breadcrumbs) {
		return preg_replace('@\[et_pb_dmb_breadcrumbs[^\]]*?\](.*?\[\/et_pb_dmb_breadcrumbs\])?@si', '', $content);
	}
	
	return $content; 
}


