<?php
/**
 * The style "default" of the Services Item
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_services');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
$link = get_permalink();

if(isset($count)) {
	$left_pos = ($count == 3 || $count == 4
		|| $count == 7 || $count == 8
		|| $count == 11 || $count == 12
		|| $count == 15 || $count == 16) ? true : false;
	$num = ($count <= 10 ? '0'.$count : '').'/';
} else {
	$left_pos = '';
	$num = '';
}


if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?><?php echo $left_pos==true ? ' left' : ' right'; ?>"><?php
}
?>
<div class="sc_services_item">
	<?php if ( has_post_thumbnail() ) { ?>
		<div class="sc_services_item_avatar">
			<?php
			the_post_thumbnail( apply_filters('trx_addons_filter_services_thumb_size', trx_addons_get_thumb_size('avatar')), array('alt' => get_the_title()) )
			?>
		</div>
	<?php } ?>
	<div class="sc_services_item_info">
		<div class="sc_services_item_header">
			<h5 class="sc_services_item_title"><?php echo (!empty($num) ? '<span class="count">'.esc_html($num).'</span>' : ''); ?><a href="<?php echo esc_url($link); ?>"><?php the_title(); ?></a></h5>
		</div>
		<div class="sc_services_item_content"><?php the_excerpt(); ?></div>
		<div class="sc_services_item_button"><a href="<?php echo esc_url($link); ?>"><?php esc_html_e('Learn more', 'trx_addons'); ?></a></div>
	</div>
</div>
<?php
if ($args['columns'] > 1) {
	?></div><?php
}
?>