<?php
/**
 * Media utilities
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.0
 */

// Don't load directly
if ( ! defined( 'TRX_ADDONS_VERSION' ) ) {
	die( '-1' );
}


// Set quality to save cropped images
if (!function_exists('trx_addons_set_images_quality')) {
	add_filter( 'wp_editor_set_quality', 'trx_addons_set_images_quality', 10, 2 );
	function trx_addons_set_images_quality($defa=90, $mime='') {
		$q = (int) trx_addons_get_option('images_quality');
		if ($q == 0) $q = 90;
		return max(1, min(100, $q));
	}
}

// Get image sizes from image url (if image in the uploads folder)
if (!function_exists('trx_addons_getimagesize')) {
	function trx_addons_getimagesize($url, $echo=false) {
	
		// Get upload path & dir
		$upload_info = wp_upload_dir();

		// Where check file
		$locations = array(
			'uploads' => array(
				'dir' => $upload_info['basedir'],
				'url' => $upload_info['baseurl']
				),
			'child' => array(
				'dir' => get_stylesheet_directory(),
				'url' => get_stylesheet_directory_uri()
				),
			'theme' => array(
				'dir' => get_template_directory(),
				'url' => get_template_directory_uri()
				)
			);
		
		$http_prefix = "http://";
		$https_prefix = "https://";
		
		$img_size = false;
		
		foreach($locations as $key=>$loc) {
			/* if the $url scheme differs from $upload_url scheme, make them match 
			   if the schemes differe, images don't show up. */
			if (!strncmp($url, $https_prefix, strlen($https_prefix))) 		//if url begins with https:// make $upload_url begin with https:// as well
				$loc['url'] = str_replace($http_prefix, $https_prefix, $loc['url']);
			else if (!strncmp($url, $http_prefix, strlen($http_prefix))) 	//if url begins with http:// make $upload_url begin with http:// as well
				$loc['url'] = str_replace($https_prefix, $http_prefix, $loc['url']);		
			
			// Check if $img_url is local.
			if ( false === strpos($url, $loc['url']) ) continue;
			
			// Get path of image.
			$img_path = $loc['dir'] . str_replace($loc['url'], '', $url);
		
			// Check if img path exists, and is an image indeed.
			if ( !file_exists($img_path)) continue;
	
			// Get image size
			$img_size = getimagesize($img_path);
			break;
		}
		
		if ($echo && $img_size!==false && !empty($img_size[3])) {
			echo ' '.trim($img_size[3]);
		}
		
		return $img_size;
	}
}

// Return image size name with @retina modifier (if need)
if (!function_exists('trx_addons_get_thumb_size')) {
	function trx_addons_get_thumb_size($ts) {
		static $retina = '-';
		if ($retina=='-') $retina = trx_addons_get_retina_multiplier() > 1 ? '-@retina' : '';
		return apply_filters('trx_addons_filter_get_thumb_size', ($ts=='post-thumbnail' || strpos($ts, 'trx_addons-thumb-')===0 ? '' : 'trx_addons-thumb-') . $ts . $retina);
	}
}

// Clear thumb sizes from image name
if (!function_exists('trx_addons_clear_thumb_size')) {
	function trx_addons_clear_thumb_size($url) {
		$pi = pathinfo($url);
		$parts = explode('-', $pi['filename']);
		$suff = explode('x', $parts[count($parts)-1]);
		if (count($suff)==2 && (int) $suff[0] > 0 && (int) $suff[1] > 0) {
			array_pop($parts);
			$url = $pi['dirname'] . '/' . join('-', $parts) . '.' . $pi['extension'];
		}
		return $url;
	}
}

// Add thumb sizes to image name
if (!function_exists('trx_addons_add_thumb_size')) {
	function trx_addons_add_thumb_size($url, $thumb_size, $check_exists=true) {
		
		if (empty($url)) return '';

		$pi = pathinfo($url);
		$parts = explode('-', $pi['filename']);
		// Remove image sizes from filename
		$suff = explode('x', $parts[count($parts)-1]);
		if (count($suff)==2 && (int) $suff[0] > 0 && (int) $suff[1] > 0) {
			array_pop($parts);
		}
		$url = $pi['dirname'] . '/' . join('-', $parts) . '.' . $pi['extension'];

		// Add new image sizes
		global $_wp_additional_image_sizes;
		if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) && in_array( $thumb_size, array_keys( $_wp_additional_image_sizes ) ) )
			$parts[] = intval( $_wp_additional_image_sizes[$thumb_size]['width'] ) . 'x' . intval( $_wp_additional_image_sizes[$thumb_size]['height'] );
		$pi['filename'] = join('-', $parts);
		$new_url = $pi['dirname'] . '/' . $pi['filename'] . '.' . $pi['extension'];
		if ($check_exists) {
			$uploads_info = wp_upload_dir();
			$uploads_url = $uploads_info['baseurl'];
			$uploads_dir = $uploads_info['basedir'];
			if (strpos($new_url, $uploads_url)!==false) {
				if (!file_exists(str_replace($uploads_url, $uploads_dir, $new_url)))
					$new_url = $url;
			}
		}
		return $new_url;
	}
}

// Return thumb dimensions by thumb size name
if (!function_exists('trx_addons_get_thumb_dimensions')) {
	function trx_addons_get_thumb_dimensions($thumb_size) {
		$dim = array('width' => 0, 'height' => 0);
		global $_wp_additional_image_sizes;
		if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) && in_array( $thumb_size, array_keys( $_wp_additional_image_sizes ) ) ) {
			$dim['width']  = intval( $_wp_additional_image_sizes[$thumb_size]['width'] );
			$dim['height'] = intval( $_wp_additional_image_sizes[$thumb_size]['height'] );
		}
		return $dim;
	}
}

// Return image size multiplier
if (!function_exists('trx_addons_get_retina_multiplier')) {
	function trx_addons_get_retina_multiplier($force_retina=0) {
		static $mult = 0;
		if ($mult == 0) {
			$mult = min(4, max(1, $force_retina > 0 ? $force_retina : trx_addons_get_option("retina_ready")));
			if ($mult > 1 && (int) trx_addons_get_value_gpc('trx_addons_retina', 0) == 0)
				$mult = 1;
		}
		return $mult;
	}
}


// Build slider layout
if (!function_exists('trx_addons_build_slider_layout')) {
	function trx_addons_build_slider_layout($args=array(), $images=array()) {
		$args = array_merge(array(
			'mode' => 'gallery',			// gallery | posts - fromwhere get images for slider - from current post's gallery or from featured images
			'slides_type' => 'bg',			// images|bg - Use image as slide's content or as slide's background
			'controls' => 'yes',			// Show Prev/Next arrows
			'pagination' => 'no',			// Show pagination bullets
			'titles' => 'no',				// no | center | bottom | lb | rb - where put post's title on slide
			'large' => 'no',				// Show large title on the slides
			'interval' => '',				// Slides change interval
			'per_view' => 1,				// Slides per view
			'slides_space' => 0,			// Space between slides
			'height' => '',					// Slides height (if empty - auto)
			'thumb_size' => '',				// Size of images (if empty - big)
			'cat' => '',					// Category to get posts
			'ids' => '',					// Comma separated posts IDs
			'count' => 5,					// Posts number to show in slider
			'orderby' => 'date',			// Posts order by
			'order' => 'desc',				// Posts order
			'class' => ''					// Additional classes for slider container
			), $args);
		$args['per_view'] = empty($args['per_view']) ? 1 : max(1, min(8, (int) $args['per_view']));
		$args['interval'] = empty($args['interval']) ? mt_rand(5000, 10000) : max(1000, min(60000, $args['interval']));

		global $post;

		// Get images from first gallery in the current post
		if (empty($images)) {

			if ($args['mode'] == 'gallery') {						// Get images from first gallery in the current post

				$post_content = $post->post_content;
				if ( has_shortcode($post_content, 'gallery') ) {
					$gallery = get_post_gallery_images( $post );
					$num = 0;
					$images = array();
					if (count($gallery) > 0) {
						if (empty($args['thumb_size'])) {
							$thumb_size = $args['per_view'] < 2 || $args['height'] >= 250 ? 'big' : 'medium';
							$args['thumb_size'] = trx_addons_get_thumb_size($thumb_size);
						}
						foreach ( $gallery as $image_url ) {
							$num++;
							$images[] = array(
								'url' => $args['height'] >= 450 
										? trx_addons_clear_thumb_size($image_url) 
										: trx_addons_add_thumb_size($image_url, $args['thumb_size']),
								'title' => '',
								'link' => is_singular() ? '' : get_permalink()
								);
							if ($num >= $args['count']) break;
						}
					}
				}

			} else {										// Get featured images from posts in the specified category

				if (empty($args['thumb_size'])) {
					$thumb_size = $args['per_view'] < 2 || $args['height'] >= 250 ? 'big' : 'medium';
					$args['thumb_size'] = trx_addons_get_thumb_size($thumb_size);
				}

				if (!empty($args['ids'])) {
					$posts = explode(',', $args['ids']);
					$args['count'] = count($posts);
				}
			
				$q_args = array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'posts_per_page' => $args['count'],
					'ignore_sticky_posts' => true,
					'order' => $args['order'] == 'asc' ? 'asc' : 'desc',
				);
		
				$q_args = trx_addons_query_add_sort_order($q_args, $args['orderby'], $args['order']);
				$q_args = trx_addons_query_add_filters($q_args, 'thumbs');
				$q_args = trx_addons_query_add_posts_and_cats($q_args, $args['ids'], 'post', $args['cat']);
				$query = new WP_Query( $q_args );
	
				$num = 0;
				
				while ( $query->have_posts() ) { $query->the_post();
					$num++;
					$images[] = array(
						'url'  => trx_addons_get_attachment_url(get_post_thumbnail_id(get_the_ID()), $args['height'] >= 450 ? 'full' : $args['thumb_size']),
						'title'=> get_the_title(),
						'cats' => get_the_category_list(', '),
						'date' => get_the_date(),
						'link' => get_permalink()
						);
					if ($num >= $args['count']) break;
				}
				
				wp_reset_postdata();
			}
		}
		
		$num = 0;
		$output = '';
		if (is_array($images) && count($images) > 0) {
			$dim = trx_addons_get_thumb_dimensions($args['thumb_size']);
			if ($dim['height'] == 0) $dim['height'] = $dim['width'] / 16 * 9;
			$output .= '<div class="slider_swiper swiper-slider-container' . (!empty($args['class']) ? ' '.esc_attr($args['class']) : '')
					. ' slider_' . esc_attr(trx_addons_is_on($args['controls']) ? 'controls slider_controls_side' : 'nocontrols')
					. ' slider_' . esc_attr(trx_addons_is_on($args['pagination']) ? 'pagination' : 'nopagination')
					. ' slider_' . esc_attr(!trx_addons_is_off($args['titles']) ? 'titles_'.$args['titles'] : 'notitles')
					. ' slider_' . esc_attr($args['per_view']==1 ? 'one' : 'multi')
					.'"'
					.' data-ratio="'.esc_attr($dim['width'].':'.$dim['height']).'"'
					.' data-interval="'.esc_attr($args['interval']).'"'
					.' data-slides-per-view="'.esc_attr($args['per_view']).'"'
					.' data-slides-space="'.esc_attr($args['slides_space']).'"'
					.((int)$args['height']>0 ? ' style="max-'.esc_attr(trx_addons_get_css_position_from_values('', '', '', '', '', $args['height'])).'"' : '')
					.'>
					<div class="swiper-wrapper">';
			foreach ($images as $image) {
				$num++;
				if ($args['slides_type'] == 'bg') {
					$output .= '<div class="swiper-slide"'
							. ' style="background-image:url(' . esc_url($image['url']) . ');"'
							. '>'
								. (!trx_addons_is_off($args['titles']) ? '<div class="slide_overlay slide_overlay_'.(trx_addons_is_on($args['large']) ? 'large' : 'small').'">' : '');
					if (!trx_addons_is_off($args['titles']) ) {
						$output .= '<div class="slide_info slide_info_'.(trx_addons_is_on($args['large']) ? 'large' : 'small').'">';
						if (!empty($image['cats']))
							$output .= '<div class="slide_cats">' . trim($image['cats']) . '</div>';
						if (!empty($image['title'])) 
							$output .= '<h3 class="slide_title">'
										. ($image['link'] ? '<a href="'.esc_url($image['link']).'">' : '')
										. trim($image['title'])
										. ($image['link'] ? '</a>' : '')
										. '</h3>';
						if (!empty($image['date']))
							$output .= '<div class="slide_date">' . trim($image['date']) . '</div>';
						$output .= '</div>';
					} else
						$output .= ($image['link'] ? '<a href="'.esc_url($image['link']).'"></a>' : '');
					$output .= (!trx_addons_is_off($args['titles']) ? '</div>' : '')
								. '</div>';
				} else {
					$output .= '<div class="swiper-slide">'
								. ($image['link'] ? '<a href="'.esc_url($image['link']).'">' : '')
								. '<img src="' . esc_url($image['url']) . '" alt="'.esc_attr($image['title']).'">'
								. (!trx_addons_is_off($args['titles']) ? '<div class="slide_overlay">' : '');
					if (!trx_addons_is_off($args['titles']) ) {
						$output .= '<div class="slide_info slide_info_'.(trx_addons_is_on($args['large']) ? 'large' : 'small').'">';
						if (!empty($image['cats']))
							$output .= '<div class="slide_cats">' . trim($image['cats']) . '</div>';
						if (!empty($image['title'])) 
							$output .= '<h3 class="slide_title">' . trim($image['title']) . '</h3>';
						$output .= '</div>';
					}
					$output .= ($image['link'] ? '</a>' : '')
								. (!trx_addons_is_off($args['titles']) ? '</div>' : '')
								. '</div>';
				}
			}
			$output .= '</div>'
				. (trx_addons_is_on($args['controls']) 
						? '<div class="slider_controls_wrap"><a class="slider_prev swiper-button-prev" href="#"></a><a class="slider_next swiper-button-next" href="#"></a></div>' 
						: '')
				. (trx_addons_is_on($args['pagination']) 
						? '<div class="slider_pagination_wrap swiper-pagination"></div>' 
						: '')
				. '</div>';
		}
		//if (!empty($output)) trx_addons_enqueue_slider();
		return $output;
	}
}


// Return image url by attachment ID
if (!function_exists('trx_addons_get_attachment_url')) {
	function trx_addons_get_attachment_url($image_id, $size='full') {
		if ($image_id > 0) {
			$attach = wp_get_attachment_image_src($image_id, 'full');
			if (isset($attach[0]) && $attach[0]!='') {
				if ($size != 'full')
					$image_id = trx_addons_add_thumb_size($attach[0], trx_addons_get_thumb_size($size));
				else
					$image_id = $attach[0];
			}
		} else
			$image_id = trx_addons_add_thumb_size($image_id, trx_addons_get_thumb_size($size));
		return $image_id;
	}
}


// Return url from first <img> tag inserted in post
if (!function_exists('trx_addons_get_post_image')) {
	function trx_addons_get_post_image($post_text='', $src=true) {
		global $post;
		$img = '';
		if (empty($post_text)) $post_text = $post->post_content;
		if (preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"][^>]*>/i', $post_text, $matches)) {
			$img = $matches[$src ? 1 : 0][0];
		}
		return $img;
	}
}


// Return url from first <audio> tag inserted in post
if (!function_exists('trx_addons_get_post_audio')) {
	function trx_addons_get_post_audio($post_text='', $src=true) {
		global $post;
		$img = '';
		if (empty($post_text)) $post_text = $post->post_content;
		if ($src) {
			if (preg_match_all('/<audio.+src=[\'"]([^\'"]+)[\'"][^>]*>/i', $post_text, $matches)) {
				$img = $matches[1][0];
			}
		} else {
			$img = trx_addons_get_tag($post_text, '<audio', '</audio>');
			if (empty($mg)) {
				$img = do_shortcode(trx_addons_get_tag($post_text, '[audio', '[/audio]'));
			}
		}
		return $img;
	}
}


// Return url from first <video> tag inserted in post
if (!function_exists('trx_addons_get_post_video')) {
	function trx_addons_get_post_video($post_text='', $src=true) {
		global $post;
		$img = '';
		if (empty($post_text)) $post_text = $post->post_content;
		if ($src) {
			if (preg_match_all('/<video.+src=[\'"]([^\'"]+)[\'"][^>]*>/i', $post_text, $matches)) {
				$img = $matches[1][0];
			}
		} else {
			$img = trx_addons_get_tag($post_text, '<video', '</video>');
			if (empty($mg)) {
				$img = do_shortcode(trx_addons_get_tag($post_text, '[video', '[/video]'));
			}
		}
		return $img;
	}
}


// Add 'autoplay' feature in the video
if (!function_exists('trx_addons_make_video_autoplay')) {
	function trx_addons_make_video_autoplay($video) {
		if (($pos = strpos($video, '<video'))!==false) {
			$video = str_replace('<video', '<video autoplay="autoplay"', $video);
		} else if (($pos = strpos($video, '<iframe'))!==false) {
			if (preg_match('/(<iframe.+src=[\'"])([^\'"]+)([\'"][^>]*>)/i', $video, $matches)) {
				$video = $matches[1] . $matches[2] . (strpos($matches[2], '?')!==false ? '&' : '?') . 'autoplay=1' . $matches[3];
			}
		}
		return $video;
	}
}


// Return url from first <iframe> tag inserted in post
if (!function_exists('trx_addons_get_post_iframe')) {
	function trx_addons_get_post_iframe($post_text='', $src=true) {
		global $post;
		$img = '';
		if (empty($post_text)) $post_text = $post->post_content;
		if ($src) {
			if (preg_match_all('/<iframe.+src=[\'"]([^\'"]+)[\'"][^>]*>/i', $post_text, $matches)) {
				$img = $matches[1][0];
			}
		} else
			$img = trx_addons_get_tag($post_text, '<iframe', '</iframe>');
		return $img;
	}
}
