<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_instagram_feed_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_instagram_feed_theme_setup9', 9 );
	function mckinney_politics_instagram_feed_theme_setup9() {
		if (mckinney_politics_exists_instagram_feed()) {
			if (is_admin()) {
				add_filter( 'mckinney_politics_filter_importer_options',				'mckinney_politics_instagram_feed_importer_set_options' );
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_importer_required_plugins',		'mckinney_politics_instagram_feed_importer_required_plugins', 10, 2 );
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_instagram_feed_tgmpa_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'mckinney_politics_exists_instagram_feed' ) ) {
	function mckinney_politics_exists_instagram_feed() {
		return defined('SBIVER');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_instagram_feed_tgmpa_required_plugins' ) ) {
	//add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_instagram_feed_tgmpa_required_plugins');
	function mckinney_politics_instagram_feed_tgmpa_required_plugins($list=array()) {
		if (in_array('instagram-feed', mckinney_politics_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Instagram Feed', 'mckinney-politics'),
					'slug' 		=> 'instagram-feed',
					'required' 	=> false
				);
		return $list;
	}
}



// One-click import support
//------------------------------------------------------------------------

// Check Instagram Feed in the required plugins
if ( !function_exists( 'mckinney_politics_instagram_feed_importer_required_plugins' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_required_plugins',	'mckinney_politics_instagram_feed_importer_required_plugins', 10, 2 );
	function mckinney_politics_instagram_feed_importer_required_plugins($not_installed='', $list='') {
		//if (in_array('instagram_feed', mckinney_politics_storage_get('required_plugins')) && !mckinney_politics_exists_instagram_feed() )
		if (strpos($list, 'instagram-feed')!==false && !mckinney_politics_exists_instagram_feed() )
			$not_installed .= '<br>' . esc_html__('Instagram Feed', 'mckinney-politics');
		return $not_installed;
	}
}

// Set options for one-click importer
if ( !function_exists( 'mckinney_politics_instagram_feed_importer_set_options' ) ) {
	//add_filter( 'mckinney_politics_filter_importer_options',	'mckinney_politics_instagram_feed_importer_set_options' );
	function mckinney_politics_instagram_feed_importer_set_options($options=array()) {
		if (is_array($options)) {
			$options['additional_options'][] = 'sb_instagram_settings';		// Add slugs to export options for this plugin
		}
		return $options;
	}
}
?>