<?php
/**
 * Theme customizer
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

//--------------------------------------------------------------
//-- Register Customizer Controls
//--------------------------------------------------------------

define('CUSTOMIZE_PRIORITY', 200);		// Start priority for the new controls

if (!function_exists('mckinney_politics_customizer_register_controls')) {
	add_action( 'customize_register', 'mckinney_politics_customizer_register_controls', 11 );
	function mckinney_politics_customizer_register_controls( $wp_customize ) {

		// Setup standard WP Controls
		// ---------------------------------
		
		// Remove unused sections
		$wp_customize->remove_section( 'colors');
		$wp_customize->remove_section( 'static_front_page');

		// Reorder standard WP sections
		$sec = $wp_customize->get_panel( 'nav_menus' );
		if (is_object($sec)) $sec->priority = 30;
		$sec = $wp_customize->get_panel( 'widgets' );
		if (is_object($sec)) $sec->priority = 40;
		$sec = $wp_customize->get_section( 'title_tagline' );
		if (is_object($sec)) $sec->priority = 50;
		$sec = $wp_customize->get_section( 'background_image' );
		if (is_object($sec)) $sec->priority = 60;
		$sec = $wp_customize->get_section( 'header_image' );
		if (is_object($sec)) $sec->priority = 80;
		
		// Modify standard WP controls
		$sec = $wp_customize->get_control( 'blogname' );
		if (is_object($sec)) $sec->description      = esc_html__('Use "[[" and "]]" to modify style and color of parts of the text, "||" to break current line', 'mckinney-politics');
		$sec = $wp_customize->get_setting( 'blogname' );
		if (is_object($sec)) $sec->transport = 'postMessage';

		$sec = $wp_customize->get_setting( 'blogdescription' );
		if (is_object($sec)) $sec->transport = 'postMessage';
		
		$sec = $wp_customize->get_section( 'background_image' );
		if (is_object($sec)) {
			$sec->title = esc_html__('Background', 'mckinney-politics');
			$sec->description = esc_html__('Used only if "Content - Body style" equal to "boxed"', 'mckinney-politics');
		}
		
		// Move standard option 'Background Color' to the section 'Background Image'
		$wp_customize->add_setting( 'background_color', array(
			'default'        => get_theme_support( 'custom-background', 'default-color' ),
			'theme_supports' => 'custom-background',
			'transport'		 => 'postMessage',
			'sanitize_callback'    => 'sanitize_hex_color_no_hash',
			'sanitize_js_callback' => 'maybe_hash_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'background_color', array(
			'label'   => esc_html__( 'Background color', 'mckinney-politics' ),
			'section' => 'background_image',
		) ) );
		

		// Add Theme specific controls
		// ---------------------------------
		
		$panels = array('');
		$p = 0;
		$sections = array('');
		$s = 0;
		$i = 0;

		$options = mckinney_politics_storage_get('options');
		
		foreach ($options as $id=>$opt) {
			
			$i++;
			
			if (!empty($opt['hidden'])) continue;
			
			if ($opt['type'] == 'panel') {

				$sec = $wp_customize->get_panel( $id );
				if ( is_object($sec) && !empty($sec->title) ) {
					$sec->title      = $opt['title'];
					$sec->description= $opt['desc'];
					if ( !empty($opt['priority']) )	$sec->priority = $opt['priority'];
				} else {
					$wp_customize->add_panel( esc_attr($id) , array(
						'title'      => $opt['title'],
						'description'=> $opt['desc'],
						'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i
					) );
				}
				array_push($panels, $id);
				$p++;

			} else if ($opt['type'] == 'panel_end') {

				array_pop($panels);
				$p--;

			} else if ($opt['type'] == 'section') {

				$sec = $wp_customize->get_section( $id );
				if ( is_object($sec) && !empty($sec->title) ) {
					$sec->title      = $opt['title'];
					$sec->description= $opt['desc'];
					if ( !empty($opt['priority']) )	$sec->priority = $opt['priority'];
				} else {
					$wp_customize->add_section( esc_attr($id) , array(
						'title'      => $opt['title'],
						'description'=> $opt['desc'],
						'panel'  => esc_attr($panels[$p]),
						'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i
					) );
				}
				array_push($sections, $id);
				$s++;

			} else if ($opt['type'] == 'section_end') {

				array_pop($sections);
				$s--;

			} else if ($opt['type'] == 'select') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'select',
					'choices'  => $opt['options']
				) );

			} else if ($opt['type'] == 'radio') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'radio',
					'choices'  => $opt['options']
				) );

			} else if ($opt['type'] == 'switch') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( new MCKINNEY_POLITICS_Customize_Switch_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'choices'  => $opt['options']
				) ) );

			} else if ($opt['type'] == 'checkbox') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'checkbox'
				) );

			} else if ($opt['type'] == 'color') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'sanitize_hex_color',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'image') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if (in_array($opt['type'], array('media', 'audio', 'video'))) {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'info') {
			
				$wp_customize->add_setting( $id, array(
					'default'           => '',
					'sanitize_callback' => 'mckinney_politics_sanitize_value',
					'transport'         => 'postMessage'
				) );

				$wp_customize->add_control( new MCKINNEY_POLITICS_Customize_Info_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'hidden') {
			
				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_html',
					'transport'         => 'postMessage'
				) );

				$wp_customize->add_control( new MCKINNEY_POLITICS_Customize_Hidden_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else {	// if ($opt['type'] == 'text') {

				$wp_customize->add_setting( $id, array(
					'default'           => mckinney_politics_get_theme_option($id),
					'sanitize_callback' => 'mckinney_politics_sanitize_html',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );
			
				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => $opt['type']	//'text'
				) );
			}

		}
	}
}


// Create custom controls for customizer
if (!function_exists('mckinney_politics_customizer_custom_controls')) {
	add_action( 'customize_register', 'mckinney_politics_customizer_custom_controls' );
	function mckinney_politics_customizer_custom_controls( $wp_customize ) {
	
		class MCKINNEY_POLITICS_Customize_Info_Control extends WP_Customize_Control {
			public $type = 'info';

			public function render_content() {
				?>
				<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<span class="customize-control-description desctiption"><?php echo esc_html( $this->description ); ?></span>
				</label>
				<?php
			}
		}
	
		class MCKINNEY_POLITICS_Customize_Switch_Control extends WP_Customize_Control {
			public $type = 'switch';

			public function render_content() {
				?>
				<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<span class="customize-control-description desctiption"><?php echo esc_html( $this->description ); ?></span>
				<?php
				if (is_array($this->choices) && count($this->choices)>0) {
					foreach ($this->choices as $k=>$v) {
						?><label><input type="radio" name="_customize-radio-<?php echo esc_attr($this->id); ?>" <?php $this->link(); ?> value="<?php echo esc_attr($k); ?>">
						<?php echo esc_html($v); ?></label><?php
					}
				}
				?>
				</label>
				<?php
			}
		}
	
		class MCKINNEY_POLITICS_Customize_Hidden_Control extends WP_Customize_Control {
			public $type = 'info';

			public function render_content() {
				?>
				<input type="hidden" name="_customize-hidden-<?php echo esc_attr($this->id); ?>" <?php $this->link(); ?> value="">
				<?php
			}
		}
	
	}
}


// Sanitize plain value
if (!function_exists('mckinney_politics_sanitize_value')) {
	function mckinney_politics_sanitize_value($value) {
		return empty($value) ? $value : trim(strip_tags($value));
	}
}


// Sanitize html value
if (!function_exists('mckinney_politics_sanitize_html')) {
	function mckinney_politics_sanitize_html($value) {
		return empty($value) ? $value : wp_kses_data($value);
	}
}


//--------------------------------------------------------------
// Save custom settings in CSS file
//--------------------------------------------------------------

// Save CSS with custom colors and fonts after save custom options
if (!function_exists('mckinney_politics_customizer_action_save_after')) {
	add_action('customize_save_after', 'mckinney_politics_customizer_action_save_after');
	function mckinney_politics_customizer_action_save_after($api=false) {
		$settings = $api->settings();
		// Store new schemes colors
		$schemes = mckinney_politics_unserialize($settings['scheme_storage']->value());
		if (is_array($schemes) && count($schemes) > 0) 
			mckinney_politics_storage_set('schemes', $schemes);
		// Regenerate CSS with new colors
		mckinney_politics_customizer_save_css();
	}
}

// Save CSS with custom colors and fonts after switch theme
if (!function_exists('mckinney_politics_customizer_action_switch_theme')) {
	//add_action('after_switch_theme', 'mckinney_politics_customizer_action_switch_theme');
	function mckinney_politics_customizer_action_switch_theme() {
		mckinney_politics_customizer_save_css();
	}
}

// Save CSS with custom colors and fonts into custom.css
if (!function_exists('mckinney_politics_customizer_save_css')) {
	add_action('trx_addons_action_save_options', 'mckinney_politics_customizer_save_css');
	function mckinney_politics_customizer_save_css() {
		$msg = 	'/* ' . esc_html__("ATTENTION! This file was generated automatically! Don't change it!!!", 'mckinney-politics') 
				. "\n----------------------------------------------------------------------- */\n";

		// Save CSS with custom colors and fonts into custom.css
		$css = mckinney_politics_customizer_get_css();
		$file = mckinney_politics_get_file_dir('css/__colors.css');
		if (file_exists($file)) mckinney_politics_fpc($file, $msg . $css );

		// Merge CSS and JS with static styles and scripts

		// Merge styles
		$css = '';
		if ( ($css = apply_filters( 'mckinney_politics_filter_merge_styles', $css )) != '')
			mckinney_politics_fpc( mckinney_politics_get_file_dir('css/__styles.css'), $msg . mckinney_politics_minify_css( $css ) );

		// Merge scripts
		$js = mckinney_politics_fgc(mckinney_politics_get_file_dir('js/skip-link-focus.js'))
			. mckinney_politics_fgc(mckinney_politics_get_file_dir('js/superfish.js'))
			. mckinney_politics_fgc(mckinney_politics_get_file_dir('js/bideo.js'))
			. mckinney_politics_fgc(mckinney_politics_get_file_dir('js/_utils.js'))
			. mckinney_politics_fgc(mckinney_politics_get_file_dir('js/_init.js'));
		if ( ($js = apply_filters( 'mckinney_politics_filter_merge_scripts', $js )) != '')
			mckinney_politics_fpc( mckinney_politics_get_file_dir('js/__scripts.js'), $msg . mckinney_politics_minify_js( $js ) );
	}
}


//--------------------------------------------------------------
// Color schemes manipulations
//--------------------------------------------------------------

// Load saved values into color schemes
if (!function_exists('mckinney_politics_load_schemes')) {
	//add_action('mckinney_politics_action_load_options', 'mckinney_politics_load_schemes');
	function mckinney_politics_load_schemes() {
		$schemes = mckinney_politics_unserialize(mckinney_politics_get_theme_option('scheme_storage'));
		if (is_array($schemes) && count($schemes) > 0) 
			mckinney_politics_storage_set('schemes', $schemes);
	}
}

// Return specified color from current (or specified) color scheme
if ( !function_exists( 'mckinney_politics_get_scheme_color' ) ) {
	function mckinney_politics_get_scheme_color($color_name, $scheme = '') {
		if (empty($scheme)) $scheme = mckinney_politics_get_theme_option( 'color_scheme' );
		if (empty($scheme) || mckinney_politics_storage_empty('schemes', $scheme)) $scheme = 'default';
		$colors = mckinney_politics_storage_get_array('schemes', $scheme, 'colors');
		return $colors[$color_name];
	}
}

// Return colors from current color scheme
if ( !function_exists( 'mckinney_politics_get_scheme_colors' ) ) {
	function mckinney_politics_get_scheme_colors($scheme = '') {
		if (empty($scheme)) $scheme = mckinney_politics_get_theme_option( 'color_scheme' );
		if (empty($scheme) || mckinney_politics_storage_empty('schemes', $scheme)) $scheme = 'default';
		return mckinney_politics_storage_get_array('schemes', $scheme, 'colors');
	}
}

// Return list schemes
if ( !function_exists( 'mckinney_politics_get_theme_schemes' ) ) {
	function mckinney_politics_get_theme_schemes() {
		$list = array();
		$schemes = mckinney_politics_storage_get('schemes');
		if (is_array($schemes) && count($schemes) > 0) {
			foreach ($schemes as $slug => $scheme) {
				$list[$slug] = $scheme['title'];
			}
		}
		return $list;
	}
}

// Return theme fonts settings
if ( !function_exists( 'mckinney_politics_get_theme_fonts' ) ) {
	function mckinney_politics_get_theme_fonts($tag = '') {
		return !empty($tag) && !mckinney_politics_storage_empty('theme_fonts', $tag) 
					? mckinney_politics_storage_get_array('theme_fonts', $tag) 
					: mckinney_politics_storage_get('theme_fonts');
	}
}


//--------------------------------------------------------------
// Customizer JS and CSS
//--------------------------------------------------------------

// Binds JS listener to make Customizer color_scheme control.
// Passes color scheme data as colorScheme global.
if ( !function_exists( 'mckinney_politics_customizer_control_js' ) ) {
	add_action( 'customize_controls_enqueue_scripts', 'mckinney_politics_customizer_control_js' );
	function mckinney_politics_customizer_control_js() {
		mckinney_politics_enqueue_style( 'mckinney_politics-customizer', mckinney_politics_get_file_url('theme-options/theme.customizer.css') );
		mckinney_politics_enqueue_script( 'mckinney_politics-customizer-color-scheme-control', mckinney_politics_get_file_url('theme-options/theme.customizer.color-scheme.js'), array( 'customize-controls', 'iris', 'underscore', 'wp-util' ) );
		wp_localize_script( 'mckinney_politics-customizer-color-scheme-control', 'mckinney_politics_color_schemes', mckinney_politics_storage_get('schemes') );
		wp_localize_script( 'mckinney_politics-customizer-color-scheme-control', 'mckinney_politics_dependencies', mckinney_politics_get_theme_dependencies() );
	}
}

// Binds JS handlers to make the Customizer preview reload changes asynchronously.
if ( !function_exists( 'mckinney_politics_customizer_preview_js' ) ) {
	add_action( 'customize_preview_init', 'mckinney_politics_customizer_preview_js' );
	function mckinney_politics_customizer_preview_js() {
		mckinney_politics_enqueue_script( 'mckinney_politics-customize-preview', mckinney_politics_get_file_url('theme-options/theme.customizer.preview.js'), array( 'customize-preview' ) );
	}
}

// Output an Underscore template for generating CSS for the color scheme.
// The template generates the css dynamically for instant display in the Customizer preview.
if ( !function_exists( 'mckinney_politics_customizer_css_template' ) ) {
	add_action( 'customize_controls_print_footer_scripts', 'mckinney_politics_customizer_css_template' );
	function mckinney_politics_customizer_css_template() {
		$colors = array(
			
			// Whole block border and background
			'bg_color'				=> '{{ data.bg_color }}',
			'bd_color'				=> '{{ data.bd_color }}',
			
			// Text and links colors
			'text'					=> '{{ data.text }}',
			'text_light'			=> '{{ data.text_light }}',
			'text_dark'				=> '{{ data.text_dark }}',
			'text_link'				=> '{{ data.text_link }}',
			'text_hover'			=> '{{ data.text_hover }}',
		
			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '{{ data.alter_bg_color }}',
			'alter_bg_hover'		=> '{{ data.alter_bg_hover }}',
			'alter_bd_color'		=> '{{ data.alter_bd_color }}',
			'alter_bd_hover'		=> '{{ data.alter_bd_hover }}',
			'alter_text'			=> '{{ data.alter_text }}',
			'alter_light'			=> '{{ data.alter_light }}',
			'alter_dark'			=> '{{ data.alter_dark }}',
			'alter_link'			=> '{{ data.alter_link }}',
			'alter_hover'			=> '{{ data.alter_hover }}',
		
			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '{{ data.input_bg_color }}',
			'input_bg_hover'		=> '{{ data.input_bg_hover }}',
			'input_bd_color'		=> '{{ data.input_bd_color }}',
			'input_bd_hover'		=> '{{ data.input_bd_hover }}',
			'input_text'			=> '{{ data.input_text }}',
			'input_light'			=> '{{ data.input_light }}',
			'input_dark'			=> '{{ data.input_dark }}',

			// Inverse blocks (with background equal to the links color or one of accented colors)
			'inverse_text'			=> '{{ data.inverse_text }}',
			'inverse_light'			=> '{{ data.inverse_light }}',
			'inverse_dark'			=> '{{ data.inverse_dark }}',
			'inverse_link'			=> '{{ data.inverse_link }}',
			'inverse_hover'			=> '{{ data.inverse_hover }}',

			// Additional accented colors (if used in the current theme)
			// For example:
			// 'accent2'			=> '{{ data.accent2 }}',
			// 'accent2_hover'		=> '{{ data.accent2_hover }}',

		);

		$schemes = array_keys(mckinney_politics_get_list_schemes());
		if (count($schemes) > 0) {
			$tmpl_holder = 'script';
			foreach ($schemes as $scheme) {
				echo '<' . trim($tmpl_holder) . ' type="text/html" id="tmpl-mckinney_politics-color-scheme-'.esc_attr($scheme).'">'
						. trim(mckinney_politics_customizer_get_css( $colors, false, false, $scheme ))
					. '</' . trim($tmpl_holder) . '>';
			}
		}
	}
}


// Add scheme name in each selector in the CSS (priority 100 - after complete css)
if (!function_exists('mckinney_politics_customizer_add_scheme_in_css')) {
	add_action( 'mckinney_politics_filter_get_css', 'mckinney_politics_customizer_add_scheme_in_css', 100, 4 );
	function mckinney_politics_customizer_add_scheme_in_css($css, $colors, $fonts, $scheme) {
		$rez = '';
		$in_comment = $in_rule = false;
		$allow = true;
		$scheme_class = '.scheme_' . trim($scheme) . ' ';
		$self_class = '.scheme_self';
		$self_class_len = strlen($self_class);
		$css_str = str_replace(array('{{', '}}'), array('[[',']]'), $css['colors']);
		for ($i=0; $i<strlen($css_str); $i++) {
			$ch = $css_str[$i];
			if ($in_comment) {
				$rez .= $ch;
				if ($ch=='/' && $css_str[$i-1]=='*') {
					$in_comment = false;
					$allow = !$in_rule;
				}
			} else if ($in_rule) {
				$rez .= $ch;
				if ($ch=='}') {
					$in_rule = false;
					$allow = !$in_comment;
				}
			} else {
				if ($ch=='/' && $css_str[$i+1]=='*') {
					$rez .= $ch;
					$in_comment = true;
				} else if ($ch=='{') {
					$rez .= $ch;
					$in_rule = true;
				} else if ($ch==',') {
					$rez .= $ch;
					$allow = true;
				} else if (strpos(" \t\r\n", $ch)===false) {
					if ($allow && substr($css_str, $i, $self_class_len) == $self_class) {
						$rez .= trim($scheme_class);
						$i += $self_class_len - 1;
					} else
						$rez .= ($allow ? $scheme_class : '') . $ch;
					$allow = false;
				} else {
					$rez .= $ch;
				}
			}
		}
		$rez = str_replace(array('[[',']]'), array('{{', '}}'), $rez);
		$css['colors'] = $rez;
		return $css;
	}
}
	



// -----------------------------------------------------------------
// -- Page Options section
// -----------------------------------------------------------------

if ( !function_exists('mckinney_politics_init_meta_box') ) {
	add_action( 'after_setup_theme', 'mckinney_politics_init_meta_box' );
	function mckinney_politics_init_meta_box() {
		if ( is_admin() ) {
			add_action("admin_enqueue_scripts", 'mckinney_politics_add_meta_box_scripts');
			add_action('save_post',			'mckinney_politics_save_meta_box');
			add_action('add_meta_boxes',	'mckinney_politics_add_meta_box');
		}
	}
}
	
// Load required styles and scripts for admin mode
if ( !function_exists( 'mckinney_politics_add_meta_box_scripts' ) ) {
	add_action("admin_enqueue_scripts", 'mckinney_politics_add_meta_box_scripts');
	function mckinney_politics_add_meta_box_scripts() {
		// If current screen is 'Edit Page' - load fontello
		$screen = get_current_screen();
		if (mckinney_politics_allow_meta_box($screen->id) && mckinney_politics_allow_meta_box($screen->post_type)) {
			mckinney_politics_enqueue_style( 'mckinney_politics-fontello',  mckinney_politics_get_file_url('css/fontello/fontello-embedded.css') );
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui'));
			mckinney_politics_enqueue_script( 'mckinney_politics-meta-box', mckinney_politics_get_file_url('theme-options/theme.meta-box.js'), array('jquery') );
			wp_localize_script( 'mckinney_politics-meta-box', 'mckinney_politics_dependencies', mckinney_politics_get_theme_dependencies() );
		}
	}
}


// Check if meta box is allow
if (!function_exists('mckinney_politics_allow_meta_box')) {
	function mckinney_politics_allow_meta_box($post_type) {
		return apply_filters('mckinney_politics_filter_allow_meta_box', in_array($post_type, array('page', 'post')), $post_type);
	}
}

// Add meta box
if (!function_exists('mckinney_politics_add_meta_box')) {
	//add_action('add_meta_boxes', 'mckinney_politics_add_meta_box');
	function mckinney_politics_add_meta_box() {
		global $post_type;
		if (mckinney_politics_allow_meta_box($post_type)) {
			add_meta_box('mckinney_politics_meta_box_'.trim($post_type), esc_html__('Theme Options', 'mckinney-politics'), 'mckinney_politics_show_meta_box', $post_type, 'advanced', 'default');
		}
	}
}

// Callback function to show fields in meta box
if (!function_exists('mckinney_politics_show_meta_box')) {
	function mckinney_politics_show_meta_box() {
		global $post, $post_type;
		if (mckinney_politics_allow_meta_box($post_type)) {
			// Load saved options 
			$meta = get_post_meta($post->ID, 'mckinney_politics_options', true);
			$tabs_titles = $tabs_content = array();
			$options = mckinney_politics_storage_get('options');
			foreach ($options as $k=>$v) {
				if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false) continue;
				if (empty($v['override']['section']))
					$v['override']['section'] = esc_html__('General', 'mckinney-politics');
				if (!isset($tabs_titles[$v['override']['section']])) {
					$tabs_titles[$v['override']['section']] = $v['override']['section'];
					$tabs_content[$v['override']['section']] = '';
				}
				$v['val'] = isset($meta[$k]) ? $meta[$k] : 'inherit';
				$tabs_content[$v['override']['section']] .= mckinney_politics_show_meta_box_field($k, $v);
			}
			if (count($tabs_titles) > 0) {
				?>
				<div class="mckinney_politics_meta_box">
					<input type="hidden" name="meta_box_post_nonce" value="<?php echo esc_attr(wp_create_nonce(admin_url())); ?>" />
					<input type="hidden" name="meta_box_post_type" value="<?php echo esc_attr($post_type); ?>" />
					<div id="mckinney_politics_meta_box_tabs">
						<ul><?php
							$cnt = 0;
							foreach ($tabs_titles as $k=>$v) {
								$cnt++;
								?><li><a href="#mckinney_politics_meta_box_<?php echo esc_attr($cnt); ?>"><?php echo esc_html($v); ?></a></li><?php
							}
						?></ul>
						<?php
							$cnt = 0;
							foreach ($tabs_content as $k=>$v) {
								$cnt++;
								?>
								<div id="mckinney_politics_meta_box_<?php echo esc_attr($cnt); ?>" class="mckinney_politics_meta_box_section">
									<?php echo trim($v); ?>
								</div>
								<?php
							}
						?>
					</div>
				</div>
				<?php		
			}
		}
	}
}

// Display single option's field
if ( !function_exists('mckinney_politics_show_meta_box_field') ) {
	function mckinney_politics_show_meta_box_field($name, $field) {
		$inherit_state = mckinney_politics_is_inherit($field['val']);
		$output = '<div class="mckinney_politics_meta_box_item mckinney_politics_meta_box_item_'.esc_attr($field['type']).' mckinney_politics_meta_box_inherit_'.($inherit_state ? 'on' : 'off' ).'">'
						. '<h4 class="mckinney_politics_meta_box_item_title">'
							. esc_html($field['title'])
							. '<span class="mckinney_politics_meta_box_inherit_lock" id="mckinney_politics_meta_box_inherit_'.esc_attr($name).'"></span>'
						. '</h4>'
						. '<div class="mckinney_politics_meta_box_item_data">'
							. '<div class="mckinney_politics_meta_box_item_field" data-param="'.esc_attr($name).'">';
		if ($field['type']=='checkbox') {
			$output .= '<label class="mckinney_politics_meta_box_item_label">'
						. '<input type="checkbox" name="mckinney_politics_meta_box_field_'.esc_attr($name).'" value="1"'.($field['val']==1 ? ' checked="checked"' : '').' />'
						. esc_html($field['title'])
					. '</label>';
		} else if ($field['type']=='switch' || $field['type']=='radio') {
			foreach ($field['options'] as $k=>$v) {
				$output .= '<label class="mckinney_politics_meta_box_item_label">'
							. '<input type="radio" name="mckinney_politics_meta_box_field_'.esc_attr($name).'" value="'.esc_attr($k).'"'.($field['val']==$k ? ' checked="checked"' : '').' />'
							. esc_html($v)
						. '</label>';
			}
		} else if ($field['type']=='text') {
			$output .= '<input type="text" name="mckinney_politics_meta_box_field_'.esc_attr($name).'" value="'.esc_attr(mckinney_politics_is_inherit($field['val']) ? '' : $field['val']).'" />';
		} else if ($field['type']=='textarea') {
			$output .= '<textarea name="mckinney_politics_meta_box_field_'.esc_attr($name).'">'.esc_html(mckinney_politics_is_inherit($field['val']) ? '' : $field['val']).'</textarea>';
		} else if ($field['type']=='select') {
			$output .= '<select size="1" name="mckinney_politics_meta_box_field_'.esc_attr($name).'">';
			foreach ($field['options'] as $k=>$v) {
				$output .= '<option value="'.esc_attr($k).'"'.($field['val']==$k ? ' selected="selected"' : '').'>'.esc_html($v).'</option>';
			}
			$output .= '</select>';
		} else if (in_array($field['type'], array('image', 'media', 'video', 'audio'))) {
			$output .= '<input type="text" id="mckinney_politics_meta_box_field_'.esc_attr($name).'" name="mckinney_politics_meta_box_field_'.esc_attr($name).'" value="'.esc_attr(mckinney_politics_is_inherit($field['val']) ? '' : $field['val']).'" />'
					. mckinney_politics_show_custom_field('mckinney_politics_meta_box_field_'.esc_attr($name).'_button', array(
														'type'				=> 'mediamanager',
														'data_type'			=> $field['type'],
														'linked_field_id'	=> 'mckinney_politics_meta_box_field_'.esc_attr($name)),
														null)
					. '<div class="mckinney_politics_meta_box_field_preview">'
						. (mckinney_politics_is_inherit($field['val']) ? '' : ($field['val'] && $field['type']=='image' ? '<img src="' . esc_url($field['val']) . '" alt="">' : basename($field['val'])))
					. '</div>';
		}
		$output .=  	 '<div class="mckinney_politics_meta_box_inherit_cover"'.(!$inherit_state ? ' style="display:none;"' : '').'>'
							. '<span class="mckinney_politics_meta_box_inherit_label">' . esc_html__('Inherit', 'mckinney-politics') . '</span>'
							. '<input type="hidden" name="mckinney_politics_meta_box_inherit_'.esc_attr($name).'" value="'.esc_attr($inherit_state ? 'inherit' : '').'" />'
						. '</div>'
					. '</div>'
					. '<div class="mckinney_politics_meta_box_item_description">'
						. (!empty($field['override']['desc']) ? trim($field['override']['desc']) : trim($field['desc']))	// param 'desc' already processed with wp_kses()!
					. '</div>'
				. '</div>'
			. '</div>';
		return $output;
	}
}

// Save data from meta box
if (!function_exists('mckinney_politics_save_meta_box')) {
	//add_action('save_post', 'mckinney_politics_save_meta_box');
	function mckinney_politics_save_meta_box($post_id) {

		// verify nonce
		if ( !wp_verify_nonce( mckinney_politics_get_value_gp('meta_box_post_nonce'), admin_url() ) )
			return $post_id;

		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}

		$post_type = isset($_POST['meta_box_post_type']) ? $_POST['meta_box_post_type'] : $_POST['post_type'];

		// check permissions
		$capability = 'page';
		$post_types = get_post_types( array( 'name' => $post_type), 'objects' );
		if (!empty($post_types) && is_array($post_types)) {
			foreach ($post_types  as $type) {
				$capability = $type->capability_type;
				break;
			}
		}
		if (!current_user_can('edit_'.($capability), $post_id)) {
			return $post_id;
		}

		// Save meta
		$meta = array();
		$options = mckinney_politics_storage_get('options');
		foreach ($options as $k=>$v) {
			// Skip not overriden options
			if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false) continue;
			// Skip inherited options
			if (!empty($_POST['mckinney_politics_meta_box_inherit_'.trim($k)])) continue;
			// Get option value from POST
			$meta[$k] = isset($_POST['mckinney_politics_meta_box_field_'.trim($k)])
							? $_POST['mckinney_politics_meta_box_field_'.trim($k)]
							: ($v['type']=='checkbox' ? 0 : '');
		}
		update_post_meta($post_id, 'mckinney_politics_options', $meta);
	}
}


//--------------------------------------------------------------
//-- Load Options list and styles
//--------------------------------------------------------------
require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.options.php';
require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.styles.php';
?>