<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'mckinney_politics_options_theme_setup2', 2 );
	function mckinney_politics_options_theme_setup2() {
		mckinney_politics_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('mckinney_politics_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'mckinney_politics_options_theme_setup5', 5 );
	function mckinney_politics_options_theme_setup5() {
		mckinney_politics_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('mckinney_politics_load_custom_options')) {
		add_action( 'wp_loaded', 'mckinney_politics_load_custom_options' );
		function mckinney_politics_load_custom_options() {
			mckinney_politics_load_theme_options();
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('mckinney_politics_load_theme_options') ) {
	function mckinney_politics_load_theme_options() {
		$options = mckinney_politics_storage_get('options');
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$mckinney_politics_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				mckinney_politics_storage_set_array2('options', $k, 'val', isset($_GET[$k]) 
					? $_GET[$k] 
					: get_theme_mod($k, $v['std'])
					);
			}
		}
		do_action('mckinney_politics_action_load_options');
	}
}

// Override options with stored page/post meta
if ( !function_exists('mckinney_politics_override_theme_options') ) {
	add_action( 'wp', 'mckinney_politics_override_theme_options', 1 );
	function mckinney_politics_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			mckinney_politics_storage_set('blog_archive', true);
			mckinney_politics_storage_set('blog_template', get_the_ID());
		}
		mckinney_politics_storage_set('blog_mode', mckinney_politics_detect_blog_mode());
		if (is_singular()) {
			mckinney_politics_storage_set('options_meta', get_post_meta(get_the_ID(), 'mckinney_politics_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('mckinney_politics_get_theme_option')) {
	function mckinney_politics_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!mckinney_politics_storage_isset('post_options_meta', $post_id))
				mckinney_politics_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'mckinney_politics_options', true));
			if (mckinney_politics_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = mckinney_politics_storage_get_array('post_options_meta', $post_id, $name);
				if (!mckinney_politics_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && mckinney_politics_storage_isset('options')) {
			if ( !mckinney_politics_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						//array_shift($s);
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'mckinney-politics'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
						die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = mckinney_politics_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name.'_'.trim($blog_mode)])) {
					$rez = $_REQUEST[$name.'_'.trim($blog_mode)];
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = $_REQUEST[$name];
				// Override option from current page settings (if exists)
				} else if (mckinney_politics_storage_isset('options_meta', $name) && !mckinney_politics_is_inherit(mckinney_politics_storage_get_array('options_meta', $name))) {
					$rez = mckinney_politics_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && mckinney_politics_storage_isset('options', $name.'_'.trim($blog_mode), 'val') && !mckinney_politics_is_inherit(mckinney_politics_storage_get_array('options', $name.'_'.trim($blog_mode), 'val'))) {
					$rez = mckinney_politics_storage_get_array('options', $name.'_'.trim($blog_mode), 'val');
				// Get saved option value
				} else if (mckinney_politics_storage_isset('options', $name, 'val')) {
					$rez = mckinney_politics_storage_get_array('options', $name, 'val');
				// Get MCKINNEY_POLITICS_Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('mckinney_politics_check_theme_option')) {
	function mckinney_politics_check_theme_option($name) {
		return mckinney_politics_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('mckinney_politics_get_theme_dependencies') ) {
	function mckinney_politics_get_theme_dependencies() {
		$options = mckinney_politics_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('mckinney_politics_get_theme_setting')) {
	function mckinney_politics_get_theme_setting($name) {
		return mckinney_politics_storage_isset('settings', $name) ? mckinney_politics_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'mckinney_politics_set_theme_setting' ) ) {
	function mckinney_politics_set_theme_setting($option_name, $value) {
		if (mckinney_politics_storage_isset('settings', $option_name))
			mckinney_politics_storage_set_array('settings', $option_name, $value);
	}
}


// -----------------------------------------------------------------
// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
// -- Internal theme settings
// -----------------------------------------------------------------
mckinney_politics_storage_set('settings', array(
	
	'custom_sidebars'	=> 8,									// How many custom sidebars will be registered (in addition to theme preset sidebars): 0 - 10

	'ajax_views_counter'=> true,								// Use AJAX for increment posts counter (if cache plugins used) 
																// or increment posts counter then loading page (without cache plugin)
	'breadcrumbs_max_level' 	=> 3,							// Max number of the nested categories in the breadcrumbs (0 - unlimited)

	'ajax_search_types'			=> 'post,page',					// Comma separated (without spaces) post types which can be searched
	'ajax_search_posts_count'	=> 4,							// How many posts showed in the search results

	'use_mediaelements'	=> true,								// Load script "Media Elements" to play video and audio

	'max_excerpt_length'=> 60,									// Max words number for the excerpt in the blog style 'Excerpt'.
																// For style 'Classic' - get half from this value
	'message_maxlength'	=> 1000,								// Max length of the message from contact form
	
	'admin_dummy_timeout' => 1200,								// Timeframe for PHP scripts when import dummy data
	'admin_dummy_style' => 2									// 1 | 2 - Progress bar style when import dummy data
));



// -----------------------------------------------------------------
// -- Theme fonts (Google and/or custom fonts)
// -----------------------------------------------------------------
// 'theme_fonts' => array(
//		'p' => array(
//			'family' => '"Advent Pro", sans-serif',																			// (required) font family
//			'link'   => 'Advent+Pro:100,100italic,300,300italic,400,400italic,700,700italic&subset=latin,latin-ext'			// (optional) if you use Google font repository
//			),
//		'logo' => array(
//			'family' => 'Amadeus, serif',																					// (required) font family
//			'css' => '/css/font-face/Amadeus/stylesheet.css'																// (optional) if you use custom font-face
//		)
// );
//
// Allowed keys:
//		h1 ... h6	- headers
//		p			- plain text
//		logo		- logo text
//		slogan		- logo slogan text
//		menu		- menu elements
//		submenu		- submenu elements
//		info		- post meta blocks (author, date, counters, etc.)
//		link		- links
//		button		- buttons
//		input		- text input fields (single line and textareas)
//		decor		- decorative elements
mckinney_politics_storage_set('theme_fonts', array(
	'p' => array(					// Text
		'family'=> '"Roboto", sans-serif',
		'link'	=> 'Roboto:400,300,500,400italic,300italic,500italic,700,700italic'
		),
	'h1' => array(
		'family'=> '"Old Standard TT", serif',
		'link'	=> 'Old+Standard+TT:400,700,400italic'
		),
	'h2' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'h3' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'h4' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'h5' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'h6' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'input' => array(
		'family'=> '"Roboto", sans-serif'
		),
	'logo' => array(
		'family'=> '"Old Standard TT", serif'
		),
	'info' => array(
		'family'=> '"Roboto", sans-serif'
		),
	'menu' => array(
		'family'=> '"Roboto", sans-serif'
		),
	'submenu' => array(
		'family'=> '"Roboto", sans-serif'
		)
));


// -----------------------------------------------------------------
// -- Theme colors for customizer
// -- Attention! Inner scheme must be last in the array below
// -----------------------------------------------------------------
mckinney_politics_storage_set('schemes', array(

	// Color scheme: 'default'
	'default' => array(
		'title'	 => esc_html__('Default', 'mckinney-politics'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#ffffff',
			'bd_color'				=> '#142236',

			// Text and links colors
			'text'					=> '#7d7f82',
			'text_light'			=> '#a8a8a8',
			'text_dark'				=> '#2d2f31',
			'text_link'				=> '#c01b33',
			'text_hover'			=> '#142236',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#f6f6f6',
			'alter_bg_hover'		=> '#142236',
			'alter_bd_color'		=> '#e9e9e9',
			'alter_bd_hover'		=> '#c5c5c5',
			'alter_text'			=> '#5f5f5f',
			'alter_light'			=> '#9d9c9c',
			'alter_dark'			=> '#2a2a2a',
			'alter_link'			=> '#2d2f31',
			'alter_hover'			=> '#c01b33',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f6f6f6',
			'input_bg_hover'		=> '#f6f6f6',
			'input_bd_color'		=> '#f6f6f6',
			'input_bd_hover'		=> '#e3e3e3',
			'input_text'			=> '#a8a8a8',
			'input_light'			=> '#a1a1a1',
			'input_dark'			=> '#1d1d1d',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#f0f0f0',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#e39a31',
			'inverse_hover'			=> '#ffffff',

			// Additional accented colors (if used in the current theme)
			// For example:
			// 'accent2'			=> '',
			// 'accent2_hover'		=> '',
		
		)
	),

	// Color scheme: 'dark'
	'dark' => array(
		'title'  => esc_html__('Dark', 'mckinney-politics'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#142236',
			'bd_color'				=> '#0f1a29',

			// Text and links colors
			'text'					=> '#a8a8a8',
			'text_light'			=> '#ffffff',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#c01b33',
			'text_hover'			=> '#ffffff',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#343434',
			'alter_bg_hover'		=> '#4c4c4c',
			'alter_bd_color'		=> '#1d1d1d',
			'alter_bd_hover'		=> '#292929',
			'alter_text'			=> '#909090',
			'alter_light'			=> '#aaaaaa',
			'alter_dark'			=> '#eeeeee',
			'alter_link'			=> '#ffffff',
			'alter_hover'			=> '#c01b33',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#0f1a29',
			'input_bg_hover'		=> '#0f1a29',
			'input_bd_color'		=> '#0f1a29',
			'input_bd_hover'		=> '#4c4c4c',
			'input_text'			=> '#aaaaaa',
			'input_light'			=> '#888888',
			'input_dark'			=> '#eeeeee',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#c01b33',
			'inverse_hover'			=> '#ffffff',
		
		)
	),

	// Color scheme: 'light'
	'light' => array(
		'title'	 => esc_html__('Light', 'mckinney-politics'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#f6f6f6',
			'bd_color'				=> '#c7c7c7',

			// Text and links colors
			'text'					=> '#5f5f5f',
			'text_light'			=> '#9d9c9c',
			'text_dark'				=> '#2a2a2a',
			'text_link'				=> '#c01b33',
			'text_hover'			=> '#2d2f31',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#ffffff',
			'alter_bg_hover'		=> '#f0f0f0',
			'alter_bd_color'		=> '#e5e5e5',
			'alter_bd_hover'		=> '#d5d5d5',
			'alter_text'			=> '#7a7a7a',
			'alter_light'			=> '#9d9c9c',
			'alter_dark'			=> '#2a2a2a',
			'alter_link'			=> '#e39a31',
			'alter_hover'			=> '#2a2a2a',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#ffffff',
			'input_bg_hover'		=> '#ffffff',
			'input_bd_color'		=> '#ffffff',
			'input_bd_hover'		=> '#c6c6c6',
			'input_text'			=> '#7a7a7a',
			'input_light'			=> '#a1a1a1',
			'input_dark'			=> '#2a2a2a',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#e39a31',
			'inverse_hover'			=> '#ffffff',
		
		)
	)

));



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('mckinney_politics_options_create')) {

	function mckinney_politics_options_create() {

		mckinney_politics_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'mckinney-politics') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'mckinney-politics') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'mckinney-politics'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_video' => array(
				"title" => esc_html__('Header video', 'mckinney-politics'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => '',
				"type" => "video"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Fullheight Header', 'mckinney-politics'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 'header-1',
				"options" => mckinney_politics_get_list_header_styles(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 'default',
				"options" => mckinney_politics_get_list_header_positions(),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 'inherit',
				"options" => mckinney_politics_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select style to display the main menu', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 'top',
				"options" => mckinney_politics_get_list_menu_styles(),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 'inherit',
				"options" => mckinney_politics_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_cache' => array(
				"title" => esc_html__('Use menu cache', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Use cache for the menu (increase theme speed, decrease queries number). Attention! Please, save menu again after change permalink settings!', 'mckinney-politics') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'search_style' => array(
				"title" => esc_html__('Search in the header', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select style of the search field in the header', 'mckinney-politics') ),
				"std" => 'fullscreen',
				"options" => array(
					'expand' => esc_html__('Expand', 'mckinney-politics'),
					'fullscreen' => esc_html__('Fullscreen', 'mckinney-politics')
				),
				"type" => "switch"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'mckinney-politics') ),
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => mckinney_politics_get_list_range(0,6),
				"type" => "select"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'show_page_title' => array(
				"title" => esc_html__('Show Page Title', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Do you want to show page title area (page/post/category title and breadcrumbs)?', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'mckinney-politics')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'show_breadcrumbs' => array(
				"title" => esc_html__('Show breadcrumbs', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Do you want to show breadcrumbs in the page title area?', 'mckinney-politics') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'mckinney-politics') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'mckinney-politics') ),
				"std" => '',
				"type" => "image"
				),
			'mobile_layout_width' => array(
				"title" => esc_html__('Mobile layout from', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Window width to show mobile layout of the header', 'mckinney-politics') ),
				"std" => 959,
				"type" => "text"
				),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Options for the content area', 'mckinney-politics') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select width of the body content', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => mckinney_politics_get_list_body_styles(),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"std" => 'default',
				"options" => mckinney_politics_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'dark',
				"options" => mckinney_politics_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_courses,cpt_services',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => mckinney_politics_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'mckinney-politics')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'mckinney-politics') ),
				"type" => "section"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'mckinney-politics')
				),
				"std" => 'dark',
				"options" => mckinney_politics_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'mckinney-politics')
				),
				"std" => 'footer_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'mckinney-politics')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => mckinney_politics_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'mckinney-politics')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'mckinney-politics') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'mckinney-politics') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'mckinney-politics') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'mckinney-politics') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Copyright text in the footer', 'mckinney-politics') ),
				"std" => esc_html__('AxiomThemes &copy; {Y}. All rights reserved. Terms of use and Privacy Policy', 'mckinney-politics'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'mckinney-politics') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'mckinney-politics') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'mckinney-politics') ),
				"std" => 'excerpt',
				"options" => mckinney_politics_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'mckinney-politics') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'mckinney-politics') ),
				"std" => 'header_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'mckinney-politics') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'mckinney-politics') ),
				"refresh" => false,
				"std" => 'right',
				"options" => mckinney_politics_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'mckinney-politics') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'mckinney-politics') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"dependency" => array(
					'#page_template' => array('blog.php')
				),
				"std" => 'excerpt',
				"options" => mckinney_politics_get_list_blog_styles(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"dependency" => array(
					'#page_template' => array('blog.php')
				),
				"std" => '0',
				"options" => mckinney_politics_array_merge(array(0 => esc_html__('- Select category -', 'mckinney-politics')), mckinney_politics_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"dependency" => array(
					'#page_template' => array('blog.php')
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"std" => "pages",
				"options" => mckinney_politics_get_list_paginations(),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'mckinney-politics') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'mckinney-politics'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'mckinney-politics') ),
				"std" => "excerpt",
				"options" => mckinney_politics_get_list_blog_content(),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for posts', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'mckinney-politics')
				),
				"dependency" => array(
					'#page_template' => array('blog.php')
				),
				"std" => "none",
				"options" => mckinney_politics_get_list_animations_in(),
				"type" => "select"
				),
			"animation_on_mobile" => array( 
				"title" => esc_html__('Allow animation on mobile', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Allow extended animation effects on mobile devices', 'mckinney-politics') ),
				"std" => 'yes',
				"dependency" => array(
					'blog_animation' => array('^none')
				),
				"options" => mckinney_politics_get_list_yesno(),
				"type" => "switch"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'mckinney-politics') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'mckinney-politics') ),
				"refresh" => false,
				"std" => 'right',
				"options" => mckinney_politics_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('Color scheme editor', 'mckinney-politics'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'mckinney-politics') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'mckinney-politics') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'mckinney-politics'),
				"desc" => '',
				"std" => 'simple',
				"options" => mckinney_politics_get_list_user_skills(),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'mckinney-politics') ),
				"std" => 'default',
				"options" => mckinney_politics_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'mckinney-politics'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'mckinney-politics'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'mckinney-politics') ),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'mckinney-politics') ),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the active field', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'mckinney-politics') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$mckinney_politics_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Hidden options for override in the posts
			'media_title' => array(
				"title" => esc_html__('Media title', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'mckinney-politics')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'mckinney-politics'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'mckinney-politics') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'mckinney-politics')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),

		));
	}
}
?>