<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Get theme variable
if (!function_exists('mckinney_politics_storage_get')) {
	function mckinney_politics_storage_get($var_name, $default='') {
		global $MCKINNEY_POLITICS_STORAGE;
		return isset($MCKINNEY_POLITICS_STORAGE[$var_name]) ? $MCKINNEY_POLITICS_STORAGE[$var_name] : $default;
	}
}

// Set theme variable
if (!function_exists('mckinney_politics_storage_set')) {
	function mckinney_politics_storage_set($var_name, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		$MCKINNEY_POLITICS_STORAGE[$var_name] = $value;
	}
}

// Check if theme variable is empty
if (!function_exists('mckinney_politics_storage_empty')) {
	function mckinney_politics_storage_empty($var_name, $key='', $key2='') {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!empty($key) && !empty($key2))
			return empty($MCKINNEY_POLITICS_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return empty($MCKINNEY_POLITICS_STORAGE[$var_name][$key]);
		else
			return empty($MCKINNEY_POLITICS_STORAGE[$var_name]);
	}
}

// Check if theme variable is set
if (!function_exists('mckinney_politics_storage_isset')) {
	function mckinney_politics_storage_isset($var_name, $key='', $key2='') {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!empty($key) && !empty($key2))
			return isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key][$key2]);
		else if (!empty($key))
			return isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key]);
		else
			return isset($MCKINNEY_POLITICS_STORAGE[$var_name]);
	}
}

// Inc/Dec theme variable with specified value
if (!function_exists('mckinney_politics_storage_inc')) {
	function mckinney_politics_storage_inc($var_name, $value=1) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (empty($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = 0;
		$MCKINNEY_POLITICS_STORAGE[$var_name] += $value;
	}
}

// Concatenate theme variable with specified value
if (!function_exists('mckinney_politics_storage_concat')) {
	function mckinney_politics_storage_concat($var_name, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (empty($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = '';
		$MCKINNEY_POLITICS_STORAGE[$var_name] .= $value;
	}
}

// Get array (one or two dim) element
if (!function_exists('mckinney_politics_storage_get_array')) {
	function mckinney_politics_storage_get_array($var_name, $key, $key2='', $default='') {
		global $MCKINNEY_POLITICS_STORAGE;
		if (empty($key2))
			return !empty($var_name) && !empty($key) && isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key]) ? $MCKINNEY_POLITICS_STORAGE[$var_name][$key] : $default;
		else
			return !empty($var_name) && !empty($key) && isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key][$key2]) ? $MCKINNEY_POLITICS_STORAGE[$var_name][$key][$key2] : $default;
	}
}

// Set array element
if (!function_exists('mckinney_politics_storage_set_array')) {
	function mckinney_politics_storage_set_array($var_name, $key, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if ($key==='')
			$MCKINNEY_POLITICS_STORAGE[$var_name][] = $value;
		else
			$MCKINNEY_POLITICS_STORAGE[$var_name][$key] = $value;
	}
}

// Set two-dim array element
if (!function_exists('mckinney_politics_storage_set_array2')) {
	function mckinney_politics_storage_set_array2($var_name, $key, $key2, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key])) $MCKINNEY_POLITICS_STORAGE[$var_name][$key] = array();
		if ($key2==='')
			$MCKINNEY_POLITICS_STORAGE[$var_name][$key][] = $value;
		else
			$MCKINNEY_POLITICS_STORAGE[$var_name][$key][$key2] = $value;
	}
}

// Merge array elements
if (!function_exists('mckinney_politics_storage_merge_array')) {
	function mckinney_politics_storage_merge_array($var_name, $key, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if ($key==='')
			$MCKINNEY_POLITICS_STORAGE[$var_name] = array_merge($MCKINNEY_POLITICS_STORAGE[$var_name], $value);
		else
			$MCKINNEY_POLITICS_STORAGE[$var_name][$key] = array_merge($MCKINNEY_POLITICS_STORAGE[$var_name][$key], $value);
	}
}

// Add array element after the key
if (!function_exists('mckinney_politics_storage_set_array_after')) {
	function mckinney_politics_storage_set_array_after($var_name, $after, $key, $value='') {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if (is_array($key))
			mckinney_politics_array_insert_after($MCKINNEY_POLITICS_STORAGE[$var_name], $after, $key);
		else
			mckinney_politics_array_insert_after($MCKINNEY_POLITICS_STORAGE[$var_name], $after, array($key=>$value));
	}
}

// Add array element before the key
if (!function_exists('mckinney_politics_storage_set_array_before')) {
	function mckinney_politics_storage_set_array_before($var_name, $before, $key, $value='') {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if (is_array($key))
			mckinney_politics_array_insert_before($MCKINNEY_POLITICS_STORAGE[$var_name], $before, $key);
		else
			mckinney_politics_array_insert_before($MCKINNEY_POLITICS_STORAGE[$var_name], $before, array($key=>$value));
	}
}

// Push element into array
if (!function_exists('mckinney_politics_storage_push_array')) {
	function mckinney_politics_storage_push_array($var_name, $key, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if ($key==='')
			array_push($MCKINNEY_POLITICS_STORAGE[$var_name], $value);
		else {
			if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key])) $MCKINNEY_POLITICS_STORAGE[$var_name][$key] = array();
			array_push($MCKINNEY_POLITICS_STORAGE[$var_name][$key], $value);
		}
	}
}

// Pop element from array
if (!function_exists('mckinney_politics_storage_pop_array')) {
	function mckinney_politics_storage_pop_array($var_name, $key='', $defa='') {
		global $MCKINNEY_POLITICS_STORAGE;
		$rez = $defa;
		if ($key==='') {
			if (isset($MCKINNEY_POLITICS_STORAGE[$var_name]) && is_array($MCKINNEY_POLITICS_STORAGE[$var_name]) && count($MCKINNEY_POLITICS_STORAGE[$var_name]) > 0) 
				$rez = array_pop($MCKINNEY_POLITICS_STORAGE[$var_name]);
		} else {
			if (isset($MCKINNEY_POLITICS_STORAGE[$var_name][$key]) && is_array($MCKINNEY_POLITICS_STORAGE[$var_name][$key]) && count($MCKINNEY_POLITICS_STORAGE[$var_name][$key]) > 0) 
				$rez = array_pop($MCKINNEY_POLITICS_STORAGE[$var_name][$key]);
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if (!function_exists('mckinney_politics_storage_inc_array')) {
	function mckinney_politics_storage_inc_array($var_name, $key, $value=1) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if (empty($MCKINNEY_POLITICS_STORAGE[$var_name][$key])) $MCKINNEY_POLITICS_STORAGE[$var_name][$key] = 0;
		$MCKINNEY_POLITICS_STORAGE[$var_name][$key] += $value;
	}
}

// Concatenate array element with specified value
if (!function_exists('mckinney_politics_storage_concat_array')) {
	function mckinney_politics_storage_concat_array($var_name, $key, $value) {
		global $MCKINNEY_POLITICS_STORAGE;
		if (!isset($MCKINNEY_POLITICS_STORAGE[$var_name])) $MCKINNEY_POLITICS_STORAGE[$var_name] = array();
		if (empty($MCKINNEY_POLITICS_STORAGE[$var_name][$key])) $MCKINNEY_POLITICS_STORAGE[$var_name][$key] = '';
		$MCKINNEY_POLITICS_STORAGE[$var_name][$key] .= $value;
	}
}

// Call object's method
if (!function_exists('mckinney_politics_storage_call_obj_method')) {
	function mckinney_politics_storage_call_obj_method($var_name, $method, $param=null) {
		global $MCKINNEY_POLITICS_STORAGE;
		if ($param===null)
			return !empty($var_name) && !empty($method) && isset($MCKINNEY_POLITICS_STORAGE[$var_name]) ? $MCKINNEY_POLITICS_STORAGE[$var_name]->$method(): '';
		else
			return !empty($var_name) && !empty($method) && isset($MCKINNEY_POLITICS_STORAGE[$var_name]) ? $MCKINNEY_POLITICS_STORAGE[$var_name]->$method($param): '';
	}
}

// Get object's property
if (!function_exists('mckinney_politics_storage_get_obj_property')) {
	function mckinney_politics_storage_get_obj_property($var_name, $prop, $default='') {
		global $MCKINNEY_POLITICS_STORAGE;
		return !empty($var_name) && !empty($prop) && isset($MCKINNEY_POLITICS_STORAGE[$var_name]->$prop) ? $MCKINNEY_POLITICS_STORAGE[$var_name]->$prop : $default;
	}
}
?>